/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.util;

import com.constellio.plugin050.importscript.HttpConfigurations;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;

public class ImportConfigurationsManager {
    private File configFile;
    private FileInputStream configFileStream;

    public ImportConfigurationsManager(File configurationsFile) {
        this.configFile = configurationsFile;
    }

    public ImportConfigurationsManager() {
    }

    public List<File> readListOfFilesProperty(String key) {
        String value = this.readProperty(key);
        ArrayList<File> filesList = new ArrayList<File>();
        if (value != null && !value.isEmpty()) {
            String[] paths;
            for (String path : paths = value.split(",")) {
                filesList.add(new File(path.trim()));
            }
        }
        return filesList;
    }

    public List<String> readListProperty(String key) {
        String lineValue = this.readProperty(key);
        ArrayList<String> valuesList = new ArrayList<String>();
        if (lineValue != null && !lineValue.isEmpty()) {
            String[] values = lineValue.split(",");
            valuesList.addAll(Arrays.asList(values));
        }
        return valuesList;
    }

    public String readProperty(String key) {
        Properties properties = new Properties();
        try {
            FileInputStream configFileStream = new FileInputStream(this.configFile);
            properties.load(new InputStreamReader((InputStream)configFileStream, Charset.forName("UTF8")));
            String value = properties.getProperty(key);
            if (value == null || value.isEmpty()) {
                return null;
            }
            return value;
        }
        catch (IOException | NullPointerException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void writeListOfFilesProperty(String key, List<File> value) {
        String filePaths = String.join((CharSequence)",", (CharSequence[])value.stream().map(File::getAbsolutePath).toArray(String[]::new));
        this.writeProperty(key, filePaths);
    }

    public void writeProperty(String key, String value) {
        Properties properties = new Properties();
        try {
            FileInputStream configFileStream = new FileInputStream(this.configFile);
            properties.load(new InputStreamReader((InputStream)configFileStream, Charset.forName("UTF8")));
            properties.setProperty(key, value);
            FileOutputStream out = new FileOutputStream(this.configFile);
            properties.store(out, null);
            out.close();
        }
        catch (IOException e) {
            System.out.println("Une erreur est survenue lors de l'\u00e9criture du fichier de configurations.");
            e.printStackTrace();
        }
    }

    public HttpConfigurations loadConfigFile(String systemConfigFileName) {
        if (ImportConfigurationsManager.configFileExists(systemConfigFileName)) {
            this.configFile = new File(systemConfigFileName);
            String urlString = this.readProperty("server.url");
            urlString = urlString.replaceAll("/$", "");
            URL url = null;
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException e) {
                System.out.println("\n------------");
                System.out.println("\u001b[31mL'URL de Constellio saisie n'est pas une URL valide.\nVeuillez v\u00e9rifier la propri\u00e9t\u00e9 \"server.url\" dans le fichier \"configurations/systemConfigurations.properties\"\u001b[0m");
                System.out.println("La valeur saisie doit correspondre \u00e0 la valeur de la configuration \"Lien du serveur Constellio\" dans votre environnement Constellio.");
                System.out.println("\nURL saisie:\t\u001b[33m" + urlString + "\u001b[0m");
                System.out.println("Format attendu:\t \u001b[33mhttp://[domain]/constellio\u001b[0m");
                System.out.println("\n");
                System.out.println("Il est possible de un fichier de configurations \u00e0 partir de la page suivante dans Constellio");
                System.out.println("Pilotage/Importer les enregistrements/Configuration du client d'importation");
                System.out.println("--------------");
                System.out.println("\u001b[35mAppuyez sur n'importe quelle touche pour quitter.");
                Scanner input = new Scanner(System.in);
                input.nextLine();
                System.exit(0);
                throw new RuntimeException(e);
            }
            Boolean skipMissingFiles = Boolean.valueOf(this.readProperty("import.skipMissingFiles"));
            Boolean withConnectionTimeout = Boolean.valueOf(this.readProperty("import.withConnectionTimeout"));
            Boolean oauth2Login = Boolean.valueOf(this.readProperty("auth.oauth2"));
            String oauth2ClientId = this.readProperty("auth.oauth2.clientId");
            String oauth2State = this.readProperty("auth.oauth2.state");
            String collection = this.readProperty("import.collection");
            HttpConfigurations config = new HttpConfigurations(url);
            config.setCollection(collection);
            config.setConfigFile(this.configFile);
            config.setConnectUsingSSL("https".equals(url.getProtocol()));
            config.setSkipMissingFiles(skipMissingFiles);
            config.setWithConnectionTimeout(withConnectionTimeout);
            config.setAuthenticateWithOauth2(oauth2Login);
            config.setOauth2ClientId(oauth2ClientId);
            config.setOauth2State(oauth2State);
            return config;
        }
        return null;
    }

    public void createNewConfigFile(HttpConfigurations config, String configFileName) {
        System.out.println("\u00c9criture d'un nouveau fichier de configurations.");
        try {
            PrintWriter writer = new PrintWriter(configFileName, "UTF-8");
            writer.println("server.url=" + config.getServerUrl());
            writer.println("import.collection=" + config.getCollection());
            writer.close();
            File configFile = new File(configFileName);
            System.out.println(String.format("Un nouveau fichier de configuration a \u00e9t\u00e9 cr\u00e9\u00e9 dans le dossier %s", configFile.getAbsolutePath()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean configFileExists(String configFileName) {
        try {
            new FileInputStream(configFileName);
            File configFile = new File(configFileName);
            System.out.println(configFile.getAbsolutePath());
            return true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setConfigFile(File configFile) {
        this.configFile = configFile;
    }
}

