/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.networkShareConversion.ui;

import com.constellio.plugin050.importscript.HttpConfigurations;
import com.constellio.plugin050.networkShareConversion.FileSystemConverter;
import com.constellio.plugin050.networkShareConversion.FileSystemExportConfig;
import com.constellio.plugin050.networkShareConversion.FileSystemExportWriter;
import com.constellio.plugin050.util.ImportConfigurationsManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import javax.swing.JFileChooser;

public class NetworkShareExportProgram {
    public static final String TEMPLATE_FILE_NAME = "bin/TEMPLATE";
    private static final String OUTPUT_FILE_NAME = "EXPORT.xlsx";
    private static HttpConfigurations httpConfig;
    private static FileSystemExportConfig exportConfig;
    private static ImportConfigurationsManager configManager;

    public NetworkShareExportProgram(HttpConfigurations config) {
        httpConfig = config;
        File exportConfigurations = new File("configurations/exportImport.properties");
        configManager = new ImportConfigurationsManager(exportConfigurations);
    }

    public static void main(String[] args) {
        NetworkShareExportProgram.writeHeader();
        boolean inExportMenu = true;
        NetworkShareExportProgram.printExportPath();
        while (inExportMenu) {
            String userChoice;
            Scanner input = new Scanner(System.in);
            System.out.println("Menu - Exportation de partage r\u00e9seau\u001b[0m");
            System.out.println("-------------------");
            System.out.println("1. \u001b[35mG\u00e9n\u00e9rer un gabarit d'importation\u001b[0m");
            System.out.println("2. \u001b[35mConfigurations\u001b[0m");
            System.out.println("3. \u001b[34mRetour au menu principal\u001b[0m");
            switch (userChoice = input.nextLine()) {
                case "1": {
                    NetworkShareExportProgram.loadConfigurations();
                    NetworkShareExportProgram.selectPathToExport();
                    if (NetworkShareExportProgram.selectFoldersToIgnore() == -1) break;
                    NetworkShareExportProgram.setMissingConfigurations();
                    FileSystemConverter converter = new FileSystemConverter(httpConfig, exportConfig);
                    File templateFile = NetworkShareExportProgram.setTemplateFile();
                    FileSystemExportWriter writer = new FileSystemExportWriter(converter, templateFile);
                    String exportName = NetworkShareExportProgram.getExportName(exportConfig.getRootPath());
                    String exportFileName = exportName + "_EXPORT.xlsx";
                    File generatedFile = writer.exportFileSystem(new File("data/" + exportFileName));
                    if (generatedFile != null) {
                        System.out.println("\nFichier d'importation g\u00e9n\u00e9r\u00e9:");
                        configManager.writeProperty("import.filePath", generatedFile.getAbsolutePath());
                        System.out.println("\u001b[32m" + generatedFile.getAbsolutePath() + "\u001b[0m");
                        System.out.println("Le gabarit d'importation  est pr\u00eat \u00e0 \u00eatre import\u00e9!");
                        System.out.println("\n");
                    }
                    inExportMenu = false;
                    break;
                }
                case "2": {
                    NetworkShareExportProgram.loadConfigurations();
                    NetworkShareExportProgram.configurationsMenu();
                    break;
                }
                case "3": {
                    inExportMenu = false;
                    break;
                }
                default: {
                    System.out.println("\u001b[31mCommande invalide.\u001b[0m");
                }
            }
        }
    }

    private static String getExportName(List<File> rootPaths) {
        if (rootPaths != null && !rootPaths.isEmpty()) {
            if (rootPaths.size() == 1) {
                return rootPaths.get(0).getName();
            }
            File firstFolder = rootPaths.get(0);
            return new File(firstFolder.getParent()).getName();
        }
        return "new_export";
    }

    private static void selectPathToExport() {
        List<File> selectedFiles;
        System.out.println("--------");
        System.out.println("\u001b[35m\u00c9tape 1: S\u00e9lectionner le(s) dossier(s) racine(s) \u00e0 exporter\u001b[0m");
        Object defaultFolder = null;
        List<File> previouslySelectedFiles = exportConfig.getRootPath();
        if (previouslySelectedFiles == null) {
            previouslySelectedFiles = new ArrayList<File>();
        }
        if ((selectedFiles = NetworkShareExportProgram.selectFolders("S\u00e9lectionner le(s) dossier(s) racine(s) \u00e0 exporter", NetworkShareExportProgram.getDefaultFolder(previouslySelectedFiles))) != null && !selectedFiles.isEmpty()) {
            exportConfig.setRootPath(selectedFiles);
            configManager.writeListOfFilesProperty("export.root_path", selectedFiles);
        } else {
            System.out.println("\u001b[33mAucun dossier s\u00e9lectionn\u00e9\u001b[0m");
            if (exportConfig.getRootPath().isEmpty()) {
                NetworkShareExportProgram.selectPathToExport();
            }
        }
    }

    private static List<File> selectFolders(String dialogTitle, File defaultFolder) {
        int choice;
        JFileChooser folderChooser = new JFileChooser();
        folderChooser.setDialogTitle(dialogTitle);
        folderChooser.setFileSelectionMode(1);
        folderChooser.setMultiSelectionEnabled(true);
        if (defaultFolder != null && defaultFolder.exists() && defaultFolder.isDirectory()) {
            folderChooser.setCurrentDirectory(defaultFolder);
        }
        if ((choice = folderChooser.showOpenDialog(null)) == 0) {
            File[] selectedFiles = folderChooser.getSelectedFiles();
            return Arrays.stream(selectedFiles).filter(File::isDirectory).toList();
        }
        return Collections.emptyList();
    }

    private static File selectSingleFolder(String dialogTitle, File defaultFolder) {
        int choice;
        JFileChooser folderChooser = new JFileChooser();
        folderChooser.setDialogTitle(dialogTitle);
        folderChooser.setFileSelectionMode(1);
        if (defaultFolder != null && defaultFolder.exists() && defaultFolder.isDirectory()) {
            folderChooser.setCurrentDirectory(defaultFolder);
        }
        if ((choice = folderChooser.showOpenDialog(null)) == 0) {
            return folderChooser.getSelectedFile();
        }
        return null;
    }

    private static int selectFoldersToIgnore() {
        List<File> foldersToIgnore = exportConfig.getFoldersToIgnore();
        List<File> rootPathLists = configManager.readListOfFilesProperty("export.root_path");
        Object ignoredFolderString = "";
        for (File file : foldersToIgnore) {
            ignoredFolderString = (String)ignoredFolderString + file.getAbsoluteFile();
            ignoredFolderString = (String)ignoredFolderString + "\n";
        }
        System.out.println("Dossier(s) racine(s) \u00e0 exporter:");
        for (File exportRoot : rootPathLists) {
            boolean exportRootPathExists = exportRoot.exists();
            String textColor = exportRootPathExists ? "\u001b[32m" : "\u001b[31m";
            System.out.println(" " + textColor + exportRoot.getAbsolutePath() + "\u001b[0m");
        }
        System.out.println("--------");
        System.out.println("\u001b[35m\u00c9tape 2: S\u00e9lectionner les dossiers \u00e0 ignorer\u001b[0m");
        System.out.println("Dossiers ignor\u00e9s:");
        System.out.println("\u001b[33m" + (String)ignoredFolderString + "\u001b[0m");
        System.out.println("------------");
        System.out.println("1. \u001b[35mG\u00e9n\u00e9rer\u001b[0m");
        System.out.println("2. \u001b[35mAjouter un dossier \u00e0 ignorer\u001b[0m");
        System.out.println("3. \u001b[35mVider la liste des dossiers \u00e0 ignorer\u001b[0m");
        System.out.println("4. \u001b[0mAnnuler");
        Scanner input = new Scanner(System.in);
        String userChoice = input.nextLine();
        int returnValue = 0;
        while (returnValue == 0) {
            if ("1".equals(userChoice)) {
                returnValue = 1;
                break;
            }
            if ("2".equals(userChoice)) {
                List<File> newFoldersToIgnore;
                File selectedFile = NetworkShareExportProgram.selectSingleFolder("S\u00e9lectionner le dossier racine \u00e0 exporter", NetworkShareExportProgram.getDefaultFolder(rootPathLists));
                if (selectedFile != null && !(newFoldersToIgnore = configManager.readListOfFilesProperty("export.foldersToIgnore")).contains(selectedFile)) {
                    newFoldersToIgnore.add(selectedFile);
                    configManager.writeListOfFilesProperty("export.foldersToIgnore", newFoldersToIgnore);
                    exportConfig.setFoldersToIgnore(newFoldersToIgnore);
                }
                returnValue = NetworkShareExportProgram.selectFoldersToIgnore();
                continue;
            }
            if ("3".equals(userChoice)) {
                configManager.writeProperty("export.foldersToIgnore", "");
                exportConfig.setFoldersToIgnore(new ArrayList<File>());
                returnValue = NetworkShareExportProgram.selectFoldersToIgnore();
                continue;
            }
            if ("4".equals(userChoice)) {
                returnValue = -1;
                continue;
            }
            System.out.println("Commande non-reconnue.");
            returnValue = NetworkShareExportProgram.selectFoldersToIgnore();
        }
        return returnValue;
    }

    private static File getDefaultFolder(List<File> rootPathLists) {
        File firstSelectedFolder;
        if (rootPathLists.size() >= 1 && (firstSelectedFolder = rootPathLists.get(0)).exists()) {
            return new File(firstSelectedFolder.getParent());
        }
        return null;
    }

    private static void configurationsMenu() {
        System.out.println("Configurations d'exportation:");
        NetworkShareExportProgram.printExportConfigurations();
        System.out.println("------------------------------");
        Scanner input = new Scanner(System.in);
        boolean choseAnOption = false;
        block8: while (!choseAnOption) {
            String userChoice;
            System.out.println("1. Modifier les configurations");
            System.out.println("2. Retour");
            switch (userChoice = input.nextLine()) {
                case "1": {
                    choseAnOption = true;
                    exportConfig = new FileSystemExportConfig();
                    NetworkShareExportProgram.setMissingConfigurations();
                    continue block8;
                }
                case "2": {
                    choseAnOption = true;
                    continue block8;
                }
            }
            System.out.println("\u001b[31mCommande invalide.\u001b[0m");
        }
    }

    private static void printExportConfigurations() {
        System.out.println(String.format("\u001b[32m\tChemin d'exportation: \u001b[0m%s", exportConfig.getRootPath()));
        System.out.println(String.format("\u001b[32m\tUnit\u00e9 administrative: \u001b[0m%s", exportConfig.getAdministrativeUnit()));
        System.out.println(String.format("\u001b[32m\tRubrique par d\u00e9faut: \u001b[0m%s", exportConfig.getDefaultCategory()));
        System.out.println(String.format("\u001b[32m\tD\u00e9tection automatique des rubriques: \u001b[0m%b", exportConfig.isUseCategoryRegex()));
        System.out.println(String.format("\u001b[32m\tExpression r\u00e9guli\u00e8re des rubriques: \u001b[0m%s", exportConfig.getCategoryRegex()));
    }

    private static File setTemplateFile() {
        File templateFile = new File(TEMPLATE_FILE_NAME);
        while (!templateFile.exists()) {
            System.out.println(String.format("Le fichier '%s' n'a pas \u00e9t\u00e9 trouv\u00e9.", TEMPLATE_FILE_NAME));
            System.out.println("Veuillez indiquer l'emplacement du fichier \u00e0 utiliser:");
            Scanner input = new Scanner(System.in);
            String templatePath = input.nextLine();
            templateFile = new File(templatePath);
        }
        return templateFile;
    }

    private static void setMissingConfigurations() {
        NetworkShareExportProgram.configureAdministrativeUnits();
        NetworkShareExportProgram.configureCategories();
    }

    private static void configureAdministrativeUnits() {
        if (exportConfig.getAdministrativeUnit() == null) {
            String ua = NetworkShareExportProgram.promptAdministrativeUnit();
            exportConfig.setAdministrativeUnit(ua);
            configManager.writeProperty("export.administrative_unit", ua);
        } else {
            System.out.println(String.format("\u001b[32m\tUnit\u00e9 administrative: \u001b[0m%s", exportConfig.getAdministrativeUnit()));
        }
    }

    private static void printExportPath() {
        List<File> exportedFolders = configManager.readListOfFilesProperty("export.root_path");
        if (exportedFolders == null || exportedFolders.isEmpty()) {
            System.out.println("Aucun chemin d'exportation d\u00e9fini");
        } else {
            System.out.println("Dossiers export\u00e9s:");
            for (File folder : exportedFolders) {
                String color = folder.exists() ? "\u001b[32m" : "\u001b[31m";
                System.out.println(color + folder.getAbsolutePath() + "\u001b[0m");
            }
        }
        System.out.println();
    }

    private static void loadConfigurations() {
        System.out.println("Chargement des configurations...");
        if (exportConfig == null) {
            exportConfig = new FileSystemExportConfig();
            exportConfig.setRootPath(configManager.readListOfFilesProperty("export.root_path"));
            exportConfig.setAdministrativeUnit(configManager.readProperty("export.administrative_unit"));
            String useRegexConfig = configManager.readProperty("export.use_category_regex");
            exportConfig.setDefaultCategory(configManager.readProperty("export.default_category"));
            if (useRegexConfig != null) {
                exportConfig.setUseCategoryRegex(Boolean.parseBoolean(useRegexConfig));
            }
            exportConfig.setCategoryRegex(configManager.readProperty("export.category_regex"));
            exportConfig.setFoldersToIgnore(configManager.readListOfFilesProperty("export.foldersToIgnore"));
            exportConfig.setFileExtensionsToIgnore(configManager.readListProperty("export.ignoredExtensions"));
        }
    }

    private static String promptAdministrativeUnit() {
        Scanner input = new Scanner(System.in);
        System.out.println("Saisir le code de l'unit\u00e9 administrative \u00e0 utiliser");
        return input.nextLine();
    }

    private static void configureCategories() {
        if (exportConfig.isUseCategoryRegex() == null) {
            NetworkShareExportProgram.setupCategories();
        } else {
            boolean regexDefined;
            System.out.println(String.format("\u001b[32m\tD\u00e9tection automatique des rubriques: \u001b[0m%b", exportConfig.isUseCategoryRegex()));
            boolean useRegex = exportConfig.isUseCategoryRegex();
            boolean defaultCategoryDefined = exportConfig.getDefaultCategory() != null;
            boolean bl = regexDefined = exportConfig.getCategoryRegex() != null;
            if (useRegex && !regexDefined || !useRegex && !defaultCategoryDefined) {
                NetworkShareExportProgram.setupCategories();
            } else {
                if (defaultCategoryDefined) {
                    System.out.println(String.format("\u001b[32m\tRubrique par d\u00e9faut: \u001b[0m%s", exportConfig.getDefaultCategory()));
                }
                if (regexDefined) {
                    System.out.println(String.format("\u001b[32m\tExpression r\u00e9guli\u00e8re des rubriques: \u001b[0m%s", exportConfig.getCategoryRegex()));
                }
            }
        }
    }

    private static void setupCategories() {
        while (true) {
            System.out.println("D\u00e9tection des rubriques");
            System.out.println("1. Utiliser une expression r\u00e9guli\u00e8re");
            System.out.println("2. Utiliser une rubrique par d\u00e9faut");
            Scanner input = new Scanner(System.in);
            String userChoice = input.nextLine();
            if (userChoice.equals("1")) {
                System.out.println("Saisir l'expression r\u00e9guli\u00e8re \u00e0 utiliser");
                exportConfig.setUseCategoryRegex(true);
                String regex = input.nextLine();
                exportConfig.setCategoryRegex(regex);
                configManager.writeProperty("export.category_regex", regex);
                configManager.writeProperty("export.use_category_regex", Boolean.toString(true));
                return;
            }
            if (userChoice.equals("2")) {
                System.out.println("Saisir la rubrique \u00e0 utiliser");
                exportConfig.setUseCategoryRegex(false);
                String defaultCategory = input.nextLine();
                exportConfig.setDefaultCategory(defaultCategory);
                configManager.writeProperty("export.default_category", defaultCategory);
                configManager.writeProperty("export.use_category_regex", Boolean.toString(false));
                return;
            }
            System.out.println("\u001b[31mCommande invalide.\u001b[0m");
        }
    }

    private static String promptRetentionRule() {
        Scanner input = new Scanner(System.in);
        System.out.println("R\u00e8gle de conservation \u00e0 utiliser");
        return input.nextLine();
    }

    private static void writeHeader() {
        String version = System.getProperty("java.version");
        System.out.println(version);
        System.out.println("Utilitaire d'importation de partage r\u00e9seau");
        System.out.println("-----------------------------------------");
    }
}

