/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.networkShareConversion;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;

public class FileSystemParser {
    private List<File> rootPaths;
    private Collection<File> directories;
    private Collection<File> files;
    private List<File> foldersToIgnore = new ArrayList<File>();
    private List<String> fileExtensionsToIgnore = new ArrayList<String>();

    public FileSystemParser(List<File> rootPaths) {
        this.rootPaths = rootPaths;
    }

    public List<File> getRootPath() {
        return this.rootPaths;
    }

    public Collection<File> getDirectories() {
        return this.directories;
    }

    public Collection<File> getFiles() {
        return this.files;
    }

    public void parse() {
        this.directories = new ArrayList<File>();
        this.files = new ArrayList<File>();
        for (File rootDirectory : this.rootPaths) {
            System.out.println("Parcours du partage r\u00e9seau...");
            Collection<File> filesAndDirs = FileUtils.listFilesAndDirs(rootDirectory, FileFilterUtils.trueFileFilter(), FileFilterUtils.trueFileFilter());
            this.directories.addAll(this.filterDirs(filesAndDirs));
            this.files.addAll(this.filterFiles(filesAndDirs));
        }
    }

    public void listFiles() {
        for (File file : this.files) {
            System.out.println(file);
        }
    }

    public void listDirectories() {
        for (File dir : this.directories) {
            System.out.println(dir);
        }
    }

    private Collection<File> filterFiles(Collection<File> filesAndDirs) {
        ArrayList<File> files = new ArrayList<File>();
        for (File file : filesAndDirs) {
            if (!file.isFile() || this.shouldIgnoreFile(file)) continue;
            files.add(file);
        }
        return files;
    }

    private Collection<File> filterDirs(Collection<File> filesAndDirs) {
        ArrayList<File> dirs = new ArrayList<File>();
        for (File file : filesAndDirs) {
            if (!file.isDirectory() || this.shouldIgnoreFolder(file)) continue;
            dirs.add(file);
        }
        return dirs;
    }

    private boolean shouldIgnoreFolder(File folder) {
        if (this.foldersToIgnore == null) {
            return false;
        }
        for (File ignoredFolder : this.foldersToIgnore) {
            if (!folder.getAbsolutePath().startsWith(ignoredFolder.getAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    private boolean shouldIgnoreFile(File file) {
        String extension = FilenameUtils.getExtension(file.getName());
        if (this.fileExtensionsToIgnore.contains(extension)) {
            return true;
        }
        return this.shouldIgnoreFolder(file.getParentFile());
    }

    public List<File> getFoldersToIgnore() {
        return this.foldersToIgnore;
    }

    public void setFoldersToIgnore(List<File> foldersToIgnore) {
        this.foldersToIgnore = foldersToIgnore;
    }

    public List<String> getFileExtensionsToIgnore() {
        return this.fileExtensionsToIgnore;
    }

    public void setFileExtensionsToIgnore(List<String> fileExtensionsToIgnore) {
        this.fileExtensionsToIgnore = fileExtensionsToIgnore;
    }
}

