/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.networkShareConversion;

import com.constellio.plugin050.importscript.HttpConfigurations;
import com.constellio.plugin050.networkShareConversion.FetchRetentionRulesService;
import com.constellio.plugin050.networkShareConversion.FileSystemExportConfig;
import com.constellio.plugin050.networkShareConversion.FileSystemParser;
import com.constellio.plugin050.networkShareConversion.wrappers.CategoryWrapper;
import com.constellio.plugin050.networkShareConversion.wrappers.DocumentWrapper;
import com.constellio.plugin050.networkShareConversion.wrappers.FolderWrapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;

public class FileSystemConverter {
    private FileSystemParser parser;
    private List<FolderWrapper> foldersToImport;
    private List<DocumentWrapper> documentsToImport;
    private FileSystemExportConfig exportConfig;
    private HttpConfigurations httpConfig;
    private Map<String, List<String>> retentionRulesCache;
    private List<CategoryWrapper> categoriesList;
    private static final String LIST_SEPARATOR = ";";
    private static final String DATA_FOLDER = "/data/";
    private List<File> foldersToIgnore = new ArrayList<File>();
    private List<String> fileExtensionsToIgnore = new ArrayList<String>();
    private boolean isOffline = false;
    private static final String DEFAULT_CATEGORY_ENTERED_VALUE = "P";

    public void setExportConfig(FileSystemExportConfig exportConfig) {
        this.exportConfig = exportConfig;
        this.initializeParser(exportConfig);
    }

    public FileSystemConverter(HttpConfigurations httpConfig, FileSystemExportConfig exportConfig) {
        this.exportConfig = exportConfig;
        this.httpConfig = httpConfig;
        this.initializeParser(exportConfig);
    }

    public void convert() {
        System.out.println("D\u00e9marrage de l'exportation");
        System.out.println("==========================");
        this.parser.parse();
        if (this.exportConfig.isUseCategoryRegex().booleanValue()) {
            this.categoriesList = this.parseCategoriesList(this.parser.getDirectories());
        } else {
            CategoryWrapper defaultCategory = new CategoryWrapper();
            defaultCategory.setCode(this.exportConfig.getDefaultCategory());
            this.categoriesList = Arrays.asList(defaultCategory);
        }
        this.retentionRulesCache = !this.isOffline ? new FetchRetentionRulesService(this.httpConfig).fetchRetentionRules(this.categoriesList) : new HashMap<String, List<String>>();
        this.foldersToImport = this.collectFolderMetadatas(this.parser.getDirectories());
        this.documentsToImport = this.collectDocumentsMetadatas(this.parser.getFiles());
    }

    private void initializeParser(FileSystemExportConfig exportConfig) {
        this.parser = new FileSystemParser(exportConfig.getRootPath());
        this.parser.setFoldersToIgnore(exportConfig.getFoldersToIgnore());
        this.parser.setFileExtensionsToIgnore(exportConfig.getFileExtensionsToIgnore());
    }

    public List<FolderWrapper> getFoldersToImport() {
        return this.foldersToImport;
    }

    public List<DocumentWrapper> getDocumentsToImport() {
        return this.documentsToImport;
    }

    private List<FolderWrapper> collectFolderMetadatas(Collection<File> dirs) {
        ArrayList<FolderWrapper> foldersList = new ArrayList<FolderWrapper>();
        for (File dir : dirs) {
            FolderWrapper folder = new FolderWrapper();
            folder.setId(dir.getAbsolutePath());
            folder.setParent(this.findParentPath(dir, folder));
            folder.setTitle(dir.getName());
            SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            folder.setModifiedOn(dateTimeFormat.format(dir.lastModified()));
            dateTimeFormat.format(dir.lastModified());
            folder.setSchema("default");
            folder.setAdministrativeUnit(this.exportConfig.getAdministrativeUnit());
            folder.setCopyStatus(DEFAULT_CATEGORY_ENTERED_VALUE);
            String categoryCode = this.exportConfig.getDefaultCategory();
            if (this.exportConfig.isUseCategoryRegex().booleanValue()) {
                if (this.isFolderCategory(new File(folder.getId()))) {
                    CategoryWrapper category = new CategoryWrapper();
                    category.setCode(this.extractCategoryCodeFromTitle(folder.getTitle()));
                    this.categoriesList.add(category);
                    continue;
                }
                categoryCode = this.parseCategoryCode(dir);
            }
            folder.setCategory(categoryCode);
            folder.setRetentionRule(this.getFirstRetentionRule(categoryCode));
            BasicFileAttributes attributes = this.getFileAttribute(dir);
            if (attributes != null) {
                long creationTime = attributes.creationTime().toMillis();
                folder.setOpeningDate(dateFormat.format(new Date(creationTime)));
                folder.setCreatedOn(dateFormat.format(new Date(creationTime)));
            }
            foldersList.add(folder);
        }
        return foldersList;
    }

    private String extractCategoryCodeFromTitle(String title) {
        Pattern pattern = Pattern.compile(this.exportConfig.getCategoryRegex());
        Matcher matcher = pattern.matcher(title);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    private boolean isRootDirectory(String dirPath) {
        return this.parser.getRootPath().contains(new File(dirPath));
    }

    private BasicFileAttributes getFileAttribute(File file) {
        try {
            return Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<DocumentWrapper> collectDocumentsMetadatas(Collection<File> files) {
        ArrayList<DocumentWrapper> documentsList = new ArrayList<DocumentWrapper>();
        for (File file : files) {
            DocumentWrapper document = new DocumentWrapper();
            document.setId(file.getAbsolutePath());
            document.setFolder(file.getParent());
            document.setSchema("default");
            document.setTitle(file.getName());
            document.setContent(file.getAbsolutePath());
            try {
                BasicFileAttributes attributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                document.setCreationDate(LocalDateTime.ofInstant(attributes.creationTime().toInstant(), ZoneId.systemDefault()));
                document.setModificationDate(LocalDateTime.ofInstant(attributes.lastModifiedTime().toInstant(), ZoneId.systemDefault()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            documentsList.add(document);
        }
        return documentsList;
    }

    private String buildRetentionRulesString(String categoryCode) {
        List<String> retentionRules = this.retentionRulesCache.get(categoryCode);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < retentionRules.size(); ++i) {
            builder.append(retentionRules.get(i));
            if (i == retentionRules.size() - 1) continue;
            builder.append(LIST_SEPARATOR);
        }
        return builder.toString();
    }

    private String getFirstRetentionRule(String categoryCode) {
        List<String> retentionRules = this.retentionRulesCache.get(categoryCode);
        if (retentionRules != null && retentionRules.size() >= 1) {
            return this.retentionRulesCache.get(categoryCode).get(0);
        }
        System.out.println(String.format("\u001b[33mATTENTION: Il n'y a aucune r\u00e8gle de conservation associ\u00e9e la cat\u00e9gorie %s\u001b[0m", categoryCode));
        return null;
    }

    private String parseCategoryCode(File dir) {
        if (this.exportConfig.isUseCategoryRegex().booleanValue()) {
            Pattern pattern = Pattern.compile(this.exportConfig.getCategoryRegex());
            return this.findCategoryCode(dir, pattern);
        }
        return this.exportConfig.getDefaultCategory();
    }

    private String findCategoryCode(File dir, Pattern pattern) {
        Matcher matcher = pattern.matcher(dir.getName());
        if (matcher.find() && this.isFolderCategory(dir)) {
            return StringUtils.trim(matcher.group());
        }
        File parent = dir.getParentFile();
        if (parent == null) {
            return null;
        }
        return this.findCategoryCode(parent, pattern);
    }

    private List<CategoryWrapper> parseCategoriesList(Collection<File> directories) {
        ArrayList<CategoryWrapper> categoriesList = new ArrayList<CategoryWrapper>();
        for (File dir : directories) {
            if (!this.isFolderCategory(dir)) continue;
            CategoryWrapper category = new CategoryWrapper();
            category.setTitle(dir.getName());
            category.setCode(this.extractCategoryCodeFromTitle(dir.getName()));
            categoriesList.add(category);
        }
        return categoriesList;
    }

    private String findParentPath(File dir, FolderWrapper folder) {
        if (this.isRootDirectory(dir.getAbsolutePath())) {
            return null;
        }
        String parentPath = dir.getParent();
        if (!folder.getId().equals(this.parser.getRootPath()) && !this.isFolderCategory(new File(parentPath))) {
            return parentPath;
        }
        return null;
    }

    private boolean folderContainsFiles(File folder) {
        File[] files = folder.listFiles();
        if (files != null && files.length > 0) {
            for (File file : files) {
                if (!file.isFile()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isFolderRoot(File folder) {
        File parentFolder = folder.getParentFile();
        boolean testedFolderIsRoot = this.exportConfig.getRootPath().contains(new File(folder.getAbsolutePath()));
        return parentFolder == null || testedFolderIsRoot;
    }

    private boolean folderHasANonCategoryParent(File folder) {
        File parentFolder = folder.getParentFile();
        return !this.isFolderRoot(folder) && !this.isFolderCategory(parentFolder) && !this.isFolderRoot(parentFolder);
    }

    public boolean isFolderCategory(File folder) {
        if (this.exportConfig.isUseCategoryRegex().booleanValue()) {
            if (this.folderHasANonCategoryParent(folder)) {
                return false;
            }
            if (this.folderContainsFiles(folder)) {
                return false;
            }
            try {
                Pattern pattern = Pattern.compile(this.exportConfig.getCategoryRegex());
                Matcher matcher = pattern.matcher(folder.getName());
                if (matcher.find()) {
                    return true;
                }
            }
            catch (PatternSyntaxException e) {
                System.out.println(String.format("L'expression r\u00e9guli\u00e8re %s est invalide", this.exportConfig.getCategoryRegex()));
                System.out.println(e.getDescription());
                e.printStackTrace();
            }
        }
        return false;
    }

    public List<File> getFoldersToIgnore() {
        return this.foldersToIgnore;
    }

    public void setFoldersToIgnore(List<File> foldersToIgnore) {
        this.foldersToIgnore = foldersToIgnore;
    }

    public List<String> getFileExtensionsToIgnore() {
        return this.fileExtensionsToIgnore;
    }

    public void setFileExtensionsToIgnore(List<String> fileExtensionsToIgnore) {
        this.fileExtensionsToIgnore = fileExtensionsToIgnore;
    }

    public void setOffline(boolean offline) {
        this.isOffline = offline;
    }
}

