/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.networkShareConversion;

import com.constellio.plugin050.importscript.HttpConfigurations;
import com.constellio.plugin050.networkShareConversion.wrappers.CategoryWrapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class FetchRetentionRulesService {
    private HttpConfigurations httpConfigurations;

    public FetchRetentionRulesService(HttpConfigurations httpConfigurations) {
        this.httpConfigurations = httpConfigurations;
    }

    public Map<String, List<String>> fetchRetentionRules(List<CategoryWrapper> categories) {
        System.out.println("Obtention des r\u00e8gles de conservation");
        HashMap<String, List<String>> retentionRulesMap = new HashMap<String, List<String>>();
        for (CategoryWrapper category : categories) {
            try {
                List<String> retentionRules = this.getRetentionRulesForCategory(category.getCode());
                retentionRulesMap.put(category.getCode(), retentionRules);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return retentionRulesMap;
    }

    private String getFetchRetentionRulesQuery(String categoryCode) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode root = mapper.createObjectNode();
        root.put("searchTerms", "");
        root.put("collection", this.httpConfigurations.getCollection());
        root.put("schemaType", "category");
        ObjectNode filter = mapper.createObjectNode();
        filter.put("type", "and");
        ArrayNode filtersArray = mapper.createArrayNode();
        ObjectNode filterItem = mapper.createObjectNode();
        filterItem.put("type", "equal");
        filterItem.put("metadataCode", "code");
        filterItem.put("filter", categoryCode);
        filtersArray.add(filterItem);
        filter.set("filters", filtersArray);
        root.set("filter", filter);
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(root);
    }

    private JSONObject sendSearchAPIQuery(String jsonBody) {
        String SEARCH_API_ENDPOINT = "/rest/beta/records/search";
        String bearerToken = "Bearer " + this.httpConfigurations.getRefreshableTokenValue();
        try {
            URL url = new URL(this.httpConfigurations.getServerUrl() + SEARCH_API_ENDPOINT);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Authorization", "Bearer " + bearerToken);
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setDoOutput(true);
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = jsonBody.getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            int statusCode = connection.getResponseCode();
            InputStream is = statusCode >= 200 && statusCode < 300 ? connection.getInputStream() : connection.getErrorStream();
            StringBuilder response = new StringBuilder();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String responseLine;
                while ((responseLine = br.readLine()) != null) {
                    response.append(responseLine.trim());
                }
            }
            return new JSONObject(response.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<String> getRetentionRulesForCategory(String categoryCode) throws URISyntaxException {
        String JSON_RESULTS_KEY = "recordsResult";
        String JSON_RECORDS_KEY = "records";
        String JSON_METADATAS_KEY = "metadatas";
        String JSON_RETENTION_RULES_METADATA_KEY = "retentionRules";
        ArrayList<String> retentionRuleIds = new ArrayList<String>();
        try {
            String searchQuery = this.getFetchRetentionRulesQuery(categoryCode);
            JSONObject searchResults = this.sendSearchAPIQuery(searchQuery);
            JSONArray categories = searchResults.getJSONObject(JSON_RESULTS_KEY).getJSONArray(JSON_RECORDS_KEY);
            for (int i = 0; i < categories.length(); ++i) {
                JSONObject record = categories.getJSONObject(i);
                JSONObject metadatas = record.getJSONObject(JSON_METADATAS_KEY);
                if (!metadatas.has(JSON_RETENTION_RULES_METADATA_KEY)) continue;
                List<String> retentionRules = metadatas.getJSONArray(JSON_RETENTION_RULES_METADATA_KEY).toList().stream().map(Object::toString).toList();
                retentionRuleIds.addAll(retentionRules);
            }
            return retentionRuleIds;
        }
        catch (JsonProcessingException | RuntimeException e) {
            System.out.println("\u001b[31mUn probl\u00e8me est survenu lors de l'obtention des r\u00e8gles de conservation.");
            return retentionRuleIds;
        }
    }
}

