/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.importscript.ui;

import com.constellio.plugin050.importscript.CellContent;
import com.constellio.plugin050.importscript.ExcelFileImporter;
import com.constellio.plugin050.importscript.HttpConfigurations;
import com.constellio.plugin050.importscript.ui.FileExtensionFilter;
import com.constellio.plugin050.util.ImportConfigurationsManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import javax.swing.JFileChooser;

public class ImportClientProgram {
    private static final String INPUT_FOLDER_PROPERTY = "import.filePath";
    private static final String OUTPUT_FOLDER_PROPERTY = "import.outputPath";
    private static HttpConfigurations config;
    private static ImportConfigurationsManager systemConfigManager;
    private static ImportConfigurationsManager importConfigManager;
    private static boolean applicationRunning;
    private static HashMap<String, String> skippedContents;

    public ImportClientProgram(HttpConfigurations systemConfig) {
        config = systemConfig;
        systemConfigManager = new ImportConfigurationsManager(config.getConfigFile());
        File importConfigurations = new File("configurations/exportImport.properties");
        importConfigManager = new ImportConfigurationsManager(importConfigurations);
    }

    public static void main(String[] args) throws Exception {
        while (applicationRunning) {
            ImportClientProgram.importMenu();
        }
    }

    private static void importMenu() throws Exception {
        Scanner input = new Scanner(System.in);
        block10: while (applicationRunning) {
            String userChoice;
            System.out.println("\nMenu - Importation dans Constellio\u001b[0m");
            System.out.println("-----------------------------------");
            System.out.println("Gabarit d'importation s\u00e9lectionn\u00e9: ");
            System.out.println("\u001b[32m" + importConfigManager.readProperty(INPUT_FOLDER_PROPERTY) + "\u001b[0m");
            System.out.println("-----------------------------------");
            System.out.println("1. \u001b[36mLancer l'importation du gabarit\u001b[0m");
            System.out.println("2. \u001b[36mS\u00e9lectionner un gabarit diff\u00e9rent\u001b[0m");
            System.out.println("3. \u001b[34mRetour au menu principal\u001b[0m");
            switch (userChoice = input.nextLine()) {
                case "1": {
                    String tempFile = ImportClientProgram.convertFile();
                    if (tempFile == null) continue block10;
                    ImportClientProgram.uploadRecords(tempFile);
                    continue block10;
                }
                case "2": {
                    File defaultFolder = new File("./data");
                    File newTemplateFile = ImportClientProgram.selectFile("S\u00e9lectionner un gabarit \u00e0 importer", defaultFolder, Arrays.asList("xlsx"));
                    if (newTemplateFile != null && newTemplateFile.isFile()) {
                        importConfigManager.writeProperty(INPUT_FOLDER_PROPERTY, newTemplateFile.getAbsolutePath());
                    }
                    ImportClientProgram.importMenu();
                }
                case "3": {
                    applicationRunning = false;
                    continue block10;
                }
            }
            System.out.println("\u001b[31mCommande invalide.\u001b[0m");
        }
    }

    private static File selectFile(String dialogTitle, File defaultFolder, List<String> allowedFileExtensions) {
        int choice;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setDialogTitle(dialogTitle);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        if (defaultFolder != null && defaultFolder.exists() && defaultFolder.isDirectory()) {
            fileChooser.setCurrentDirectory(defaultFolder);
        }
        if (allowedFileExtensions != null && !allowedFileExtensions.isEmpty()) {
            fileChooser.setFileFilter(new FileExtensionFilter(allowedFileExtensions));
        }
        if ((choice = fileChooser.showOpenDialog(null)) == 0) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }

    private static String convertFile() throws FileNotFoundException {
        String collection = config.getCollection();
        if (collection == null) {
            Scanner input = new Scanner(System.in);
            System.out.println("Saisir le nom de la collection: ");
            collection = input.nextLine();
        }
        config.setCollection(collection);
        ExcelFileImporter importer = new ExcelFileImporter(config);
        System.out.println("Validation des m\u00e9tadonn\u00e9es...");
        File validationFile = importer.createValidationFile();
        if (importer.validateExcelFile(validationFile.getAbsolutePath())) {
            String importableFile;
            importer.readAlreadyUploadedFile();
            List<CellContent> imported = importer.uploadContent();
            skippedContents = importer.getSkippedContents();
            String string = importableFile = imported == null ? null : importer.writeImportableFile(imported);
            if (importableFile == null) {
                System.out.println("Une erreur est survenue lors de  la conversion des documents.");
                System.out.println("Veuillez v\u00e9rifier le fichier d'importation.");
            }
            return importableFile;
        }
        return null;
    }

    private static void uploadRecords(String tempFilePath) {
        System.out.println("Importation des m\u00e9tadonn\u00e9es...");
        ExcelFileImporter importer = new ExcelFileImporter(config, skippedContents);
        importer.uploadExcelFile(tempFilePath);
    }

    static {
        applicationRunning = true;
    }
}

