/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.importscript.ui;

import java.io.File;
import java.util.List;
import javax.swing.filechooser.FileFilter;

public class FileExtensionFilter
extends FileFilter {
    private List<String> allowedFileExtensions;

    public FileExtensionFilter(List<String> allowedFileExtensions) {
        this.allowedFileExtensions = allowedFileExtensions;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String fileName = file.getName().toLowerCase();
        for (String ext : this.allowedFileExtensions) {
            if (!fileName.endsWith("." + ext.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return "Extensions permises: " + String.join((CharSequence)", ", this.allowedFileExtensions);
    }
}

