/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.importscript.data.util;

import com.constellio.plugin050.importscript.data.util.AccentApostropheCleaner;
import java.io.File;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.list.UnmodifiableList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class LangUtils {
    public static <T, V extends T, D extends T> T valueOrDefault(V value, D defaultValue) {
        return (T)(value != null ? value : defaultValue);
    }

    public static Comparator<Map.Entry<String, String>> mapStringStringEntryValueComparator() {
        return new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                String s1 = AccentApostropheCleaner.removeAccents(o1.getValue());
                String s2 = AccentApostropheCleaner.removeAccents(o2.getValue());
                return s1.compareTo(s2);
            }
        };
    }

    public static LocalDate max(LocalDate date1, LocalDate date2) {
        if (date1 == null) {
            return date2;
        }
        if (date2 == null) {
            return date1;
        }
        return date1.isBefore(date2) ? date2 : date1;
    }

    public static LocalDate min(LocalDate date1, LocalDate date2) {
        if (date1 == null) {
            return date2;
        }
        if (date2 == null) {
            return date1;
        }
        return date1.isAfter(date2) ? date2 : date1;
    }

    public static LocalDateTime max(LocalDateTime date1, LocalDateTime date2) {
        if (date1 == null) {
            return date2;
        }
        if (date2 == null) {
            return date1;
        }
        return date1.isBefore(date2) ? date2 : date1;
    }

    public static LocalDateTime min(LocalDateTime date1, LocalDateTime date2) {
        if (date1 == null) {
            return date2;
        }
        if (date2 == null) {
            return date1;
        }
        return date1.isAfter(date2) ? date2 : date1;
    }

    public static <V> boolean containsAny(Collection<V> firstCollection, Collection<V> secondCollection) {
        for (V firstCollectionValue : firstCollection) {
            for (V secondCollectionValue : secondCollection) {
                if (firstCollectionValue == null || !firstCollectionValue.equals(secondCollectionValue)) continue;
                return true;
            }
        }
        return false;
    }

    public static <K, V> Map<K, V> newMapWithEntry(K key, V value) {
        HashMap<K, V> values = new HashMap<K, V>();
        values.put(key, value);
        return values;
    }

    public static boolean areNullableEqual(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null && o2 != null) {
            return false;
        }
        if (o1 != null && o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static <K, V> MapComparisonResults<K, V> compare(Map<K, V> before, Map<K, V> after) {
        Set<K> keysBefore = before.keySet();
        ListComparisonResults<K> results = LangUtils.compare(keysBefore, after.keySet());
        ArrayList modifiedEntries = new ArrayList();
        for (K key : keysBefore) {
            V valueAfter;
            V valueBefore;
            if (!after.containsKey(key) || LangUtils.areNullableEqual(valueBefore = before.get(key), valueAfter = after.get(key))) continue;
            modifiedEntries.add(new ModifiedEntry<K, V>(key, valueBefore, valueAfter));
        }
        return new MapComparisonResults(results.getNewItems(), results.getRemovedItems(), modifiedEntries);
    }

    public static <T> ListComparisonResults<T> compare(Set<T> before, Set<T> after) {
        return LangUtils.compare(new ArrayList<T>(before), new ArrayList<T>(after));
    }

    public static <T> ListComparisonResults<T> compare(List<T> before, List<T> after) {
        ArrayList<Object> newItems = new ArrayList();
        ArrayList<Object> removedItems = new ArrayList();
        if (after == null) {
            removedItems = new ArrayList<T>(before);
        } else if (before == null) {
            newItems = new ArrayList<T>(after);
        } else if (after != null && after != null) {
            if (before != null) {
                for (T item : before) {
                    if (after.contains(item) || removedItems.contains(item)) continue;
                    removedItems.add(item);
                }
            }
            if (after != null) {
                for (T item : after) {
                    if (before.contains(item) || newItems.contains(item)) continue;
                    newItems.add(item);
                }
            }
        }
        return new ListComparisonResults(newItems, removedItems);
    }

    public static boolean isEqual(Object value1, Object value2) {
        if (value1 == null) {
            return value2 == null;
        }
        return value1.equals(value2);
    }

    public static void ensureNoNullItems(List<?> items) {
        for (Object item : items) {
            if (item != null) continue;
            throw new IllegalArgumentException("Null values are not allowed in list");
        }
    }

    public static boolean isTrueOrNull(Object value) {
        return !Boolean.FALSE.equals(value);
    }

    public static boolean isFalseOrNull(Object value) {
        return !Boolean.TRUE.equals(value);
    }

    public static <T> List<T> withoutDuplicates(List<T> value) {
        return new ArrayList<T>(new HashSet<T>(value));
    }

    public static List<String> withoutDuplicatesAndNulls(List<String> value) {
        ArrayList<String> values = new ArrayList<String>(new HashSet<String>(value));
        values.remove(null);
        return values;
    }

    public static <T> List<T> withoutNulls(List<T> items) {
        return (List)LangUtils.withoutNulls(items);
    }

    public static <T> Collection<T> withoutNulls(Collection<T> userPermissionsOnRecord) {
        ArrayList<T> withoutNulls = new ArrayList<T>();
        for (T value : userPermissionsOnRecord) {
            if (value == null) continue;
            withoutNulls.add(value);
        }
        return withoutNulls;
    }

    public static int compareStrings(String value1, String value2) {
        String normalizedValue1 = AccentApostropheCleaner.removeAccents(value1).toLowerCase();
        String normalizedValue2 = AccentApostropheCleaner.removeAccents(value2).toLowerCase();
        return normalizedValue1.compareTo(normalizedValue2);
    }

    public static <T> boolean hasSameElementsNoMatterTheOrder(List<T> list1, List<T> list2) {
        HashSet<T> set1 = new HashSet<T>(list1);
        HashSet<T> set2 = new HashSet<T>(list2);
        return set1.equals(set2);
    }

    public static int countIteratorValues(Iterator<?> iterator) {
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    public static int nullableNaturalCompare(Comparable v1, Comparable v2) {
        return LangUtils.nullableNaturalCompare(v1, v2, false);
    }

    public static int nullableNaturalCompare(Comparable v1, Comparable v2, boolean placeNullsAtEnd) {
        if (v1 == null) {
            if (v2 == null) {
                return 0;
            }
            return placeNullsAtEnd ? 1 : -1;
        }
        if (v2 == null) {
            return placeNullsAtEnd ? -1 : 1;
        }
        return v1.compareTo(v2);
    }

    public static StringReplacer replacingLiteral(String target, String replacement) {
        return new StringReplacer().replacingLiteral(target, replacement);
    }

    public static StringReplacer replacingRegex(String regex, String replacement) {
        return new StringReplacer().replacingRegex(regex, replacement);
    }

    public static boolean isEmptyList(Object modifiedValue) {
        return modifiedValue instanceof List && ((List)modifiedValue).isEmpty();
    }

    public static List<File> listFiles(File tempFolder) {
        File[] files = tempFolder.listFiles();
        return files == null ? Collections.emptyList() : Arrays.asList(files);
    }

    public static List<String> listFilenames(File tempFolder) {
        String[] files = tempFolder.list();
        return files == null ? Collections.emptyList() : Arrays.asList(files);
    }

    public static String tabs(int n) {
        return LangUtils.repeat("\t", n);
    }

    public static String repeat(String string, int n) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            sb.append(string);
        }
        return sb.toString();
    }

    public static <K, V> Map<K, V> asMap(K key1, V value1) {
        HashMap<K, V> parameters = new HashMap<K, V>();
        parameters.put(key1, value1);
        return parameters;
    }

    public static <K, V> Map<K, V> asMap(K key1, V value1, K key2, V value2) {
        HashMap<K, V> parameters = new HashMap<K, V>();
        parameters.put(key1, value1);
        parameters.put(key2, value2);
        return parameters;
    }

    public static <K, V> Map<K, V> asMap(K key1, V value1, K key2, V value2, K key3, V value3) {
        HashMap<K, V> parameters = new HashMap<K, V>();
        parameters.put(key1, value1);
        parameters.put(key2, value2);
        parameters.put(key3, value3);
        return parameters;
    }

    public static <V> Iterator<V> synchronizedIterator(final Iterator<V> nestedIterator) {
        return new Iterator<V>(){

            @Override
            public synchronized boolean hasNext() {
                return nestedIterator.hasNext();
            }

            @Override
            public synchronized V next() {
                return nestedIterator.next();
            }

            @Override
            public synchronized void remove() {
                nestedIterator.remove();
            }
        };
    }

    public static boolean isNullOrEmptyCollection(Object value) {
        return value == null || value instanceof Collection && ((Collection)value).isEmpty();
    }

    public static boolean isNotEmptyValue(Object value) {
        boolean notEmptyValue;
        boolean bl = notEmptyValue = value != null;
        if (value instanceof String) {
            notEmptyValue = StringUtils.isNotEmpty((String)value);
        }
        if (value instanceof Collection) {
            Iterator iterator = ((Collection)value).iterator();
            notEmptyValue = false;
            while (!notEmptyValue && iterator.hasNext()) {
                notEmptyValue = LangUtils.isNotEmptyValue(iterator.next());
            }
        }
        return notEmptyValue;
    }

    public static List<Throwable> getAllCauses(Throwable throwable) {
        return new UnmodifiableList<Throwable>(LangUtils.getAllCausesRecursively(throwable));
    }

    private static List<Throwable> getAllCausesRecursively(Throwable throwable) {
        ArrayList<Throwable> throwableList = new ArrayList<Throwable>();
        while (throwable != null && !throwableList.contains(throwable)) {
            throwableList.addAll(LangUtils.getAllCausesRecursively(throwable.getCause()));
            throwableList.add(throwable);
        }
        return throwableList;
    }

    public static long tryParseLong(String s2, long unparsableValue) {
        int radix = 10;
        if (s2 == null) {
            return unparsableValue;
        }
        long result = 0L;
        boolean negative = false;
        int i = 0;
        int len = s2.length();
        long limit = -9223372036854775807L;
        if (len > 0) {
            char firstChar = s2.charAt(0);
            if (firstChar < '0') {
                if (firstChar == '-') {
                    negative = true;
                    limit = Long.MIN_VALUE;
                } else if (firstChar != '+') {
                    return unparsableValue;
                }
                if (len == 1) {
                    return unparsableValue;
                }
                ++i;
            }
            long multmin = limit / (long)radix;
            while (i < len) {
                int digit;
                if ((digit = Character.digit(s2.charAt(i++), radix)) < 0) {
                    return unparsableValue;
                }
                if (result < multmin) {
                    return unparsableValue;
                }
                if ((result *= (long)radix) < limit + (long)digit) {
                    return unparsableValue;
                }
                result -= (long)digit;
            }
        } else {
            return unparsableValue;
        }
        return negative ? result : -result;
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static class ListComparisonResults<T> {
        private List<T> newItems;
        private List<T> removedItems;

        public ListComparisonResults(List<T> newItems, List<T> removedItems) {
            this.newItems = Collections.unmodifiableList(newItems);
            this.removedItems = Collections.unmodifiableList(removedItems);
        }

        public List<T> getNewItems() {
            return this.newItems;
        }

        public List<T> getRemovedItems() {
            return this.removedItems;
        }
    }

    public static class ModifiedEntry<K, V> {
        private K key;
        private V valueBefore;
        private V valueAfter;

        public ModifiedEntry(K key, V valueBefore, V valueAfter) {
            this.key = key;
            this.valueBefore = valueBefore;
            this.valueAfter = valueAfter;
        }

        public K getKey() {
            return this.key;
        }

        public V getValueBefore() {
            return this.valueBefore;
        }

        public V getValueAfter() {
            return this.valueAfter;
        }

        public int hashCode() {
            return HashCodeBuilder.reflectionHashCode((Object)this, new String[0]);
        }

        public boolean equals(Object obj) {
            return EqualsBuilder.reflectionEquals((Object)this, obj, new String[0]);
        }
    }

    public static class MapComparisonResults<K, V> {
        private List<K> newEntries;
        private List<K> removedEntries;
        private List<ModifiedEntry<K, V>> modifiedEntries;

        public MapComparisonResults(List<K> newEntries, List<K> removedEntries, List<ModifiedEntry<K, V>> modifiedEntries) {
            this.newEntries = Collections.unmodifiableList(newEntries);
            this.removedEntries = Collections.unmodifiableList(removedEntries);
            this.modifiedEntries = Collections.unmodifiableList(modifiedEntries);
        }

        public List<K> getNewEntries() {
            return this.newEntries;
        }

        public List<K> getRemovedEntries() {
            return this.removedEntries;
        }

        public List<ModifiedEntry<K, V>> getModifiedEntries() {
            return this.modifiedEntries;
        }
    }

    public static class StringReplacer {
        List<StringReplacement> stringReplacements = new ArrayList<StringReplacement>();

        public StringReplacer replacingRegex(String regex, String replacement) {
            Pattern pattern = Pattern.compile(regex);
            this.stringReplacements.add(new StringReplacement(pattern, replacement));
            return this;
        }

        public StringReplacer replacingLiteral(String target, String replacement) {
            if (!target.equals(replacement)) {
                Pattern pattern = Pattern.compile(target.toString(), 16);
                this.stringReplacements.add(new StringReplacement(pattern, replacement));
            }
            return this;
        }

        public String replaceFirst(String value) {
            String output = value;
            for (StringReplacement stringReplacement : this.stringReplacements) {
                output = stringReplacement.replaceFirst(output);
            }
            return output;
        }

        public String replaceOn(String value) {
            String output = value;
            for (StringReplacement stringReplacement : this.stringReplacements) {
                output = stringReplacement.replace(output);
            }
            return output;
        }
    }

    public static class StringReplacement {
        Pattern pattern;
        CharSequence replacement;

        public StringReplacement(Pattern pattern, CharSequence replacement) {
            this.pattern = pattern;
            this.replacement = replacement;
        }

        String replaceFirst(String value) {
            return this.pattern.matcher(value).replaceFirst(Matcher.quoteReplacement(this.replacement.toString()));
        }

        String replace(String value) {
            return this.pattern.matcher(value).replaceAll(Matcher.quoteReplacement(this.replacement.toString()));
        }
    }
}

