/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.importscript.data.util;

import com.constellio.plugin050.importscript.data.util.EncodingService;
import com.constellio.plugin050.importscript.data.util.Factory;
import com.constellio.plugin050.importscript.data.util.HashingEncoding;
import com.constellio.plugin050.importscript.data.util.StreamFactory;
import com.constellio.plugin050.importscript.exceptions.HashingServiceException;
import com.constellio.plugin050.importscript.exceptions.HashingServiceRuntimeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;

public class HashingService {
    private HashingEncoding hashingEncoding;
    private String algorithm;

    public HashingService(String algorithm, EncodingService encodingService, HashingEncoding hashingEncoding) {
        this.hashingEncoding = hashingEncoding;
        this.algorithm = algorithm;
    }

    public static HashingService forMD5(EncodingService encodingService, HashingEncoding hashingEncoding) {
        return new HashingService("MD5", encodingService, hashingEncoding);
    }

    public static HashingService forSHA1(EncodingService encodingService, HashingEncoding hashingEncoding) {
        return new HashingService("SHA1", encodingService, hashingEncoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHashFromStream(StreamFactory<InputStream> streamFactory) throws HashingServiceException {
        InputStream inputStream = null;
        try {
            inputStream = streamFactory.create("getHashFromStream");
        }
        catch (IOException e) {
            throw new HashingServiceException.CannotReadContent(e);
        }
        try {
            String string = this.getHashFromStream(inputStream);
            return string;
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    public String getHashFromStream(InputStream stream) throws HashingServiceException {
        try {
            MessageDigest messageDigest = this.getDigest();
            DigestInputStream dis = new DigestInputStream(stream, messageDigest);
            IOUtils.copy((InputStream)dis, (OutputStream)NullOutputStream.INSTANCE);
            return this.encodeDigest(messageDigest.digest());
        }
        catch (IOException e) {
            throw new HashingServiceException.CannotReadContent(e);
        }
        catch (RuntimeException e) {
            throw new HashingServiceException.CannotHashContent(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHashFromReader(StreamFactory<Reader> readerFactory) throws HashingServiceException {
        Reader reader = null;
        try {
            reader = readerFactory.create("getHashFromReader");
        }
        catch (IOException e) {
            throw new HashingServiceException.CannotReadContent(e);
        }
        try {
            String string = this.getHashFromReader(reader);
            return string;
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
    }

    public String getHashFromReader(final Reader reader) throws HashingServiceException {
        return this.getHashFromBytes(new Factory<byte[]>(){

            @Override
            public byte[] get() {
                try {
                    return IOUtils.toByteArray(reader, Charset.defaultCharset());
                }
                catch (IOException e) {
                    throw new HashingServiceRuntimeException.CannotGetHashFromReader(e);
                }
            }
        });
    }

    public String getHashFromFile(File file) throws HashingServiceException {
        String string;
        FileInputStream fis = new FileInputStream(file);
        try {
            string = this.getHashFromStream(fis);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new HashingServiceRuntimeException.CannotGetHashFromStream(e);
            }
        }
        fis.close();
        return string;
    }

    public String getHashFromBytes(final byte[] bytes) throws HashingServiceException {
        return this.getHashFromBytes(new Factory<byte[]>(){

            @Override
            public byte[] get() {
                return bytes;
            }
        });
    }

    public String getHashFromBytes(Factory<byte[]> bytesFactory) throws HashingServiceException {
        try {
            byte[] bytes;
            try {
                bytes = bytesFactory.get();
            }
            catch (RuntimeException e) {
                throw new HashingServiceException.CannotReadContent(e);
            }
            return this.doHash(bytes);
        }
        catch (RuntimeException e) {
            throw new HashingServiceException.CannotHashContent(e);
        }
    }

    public String getHashFromString(String string) throws HashingServiceException {
        return this.getHashFromBytes(string.getBytes());
    }

    String doHash(byte[] bytes) {
        MessageDigest messageDigest = this.getDigest();
        byte[] digestBytes = messageDigest.digest(bytes);
        return this.encodeDigest(digestBytes);
    }

    private MessageDigest getDigest() {
        try {
            return MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new HashingServiceRuntimeException.NoSuchAlgorithm(this.algorithm, e);
        }
    }

    String encodeDigest(byte[] digestBytes) {
        String encoded = this.hashingEncoding == HashingEncoding.BASE64_URL_ENCODED ? new EncodingService().encodeToBase64UrlEncoded(digestBytes) : (this.hashingEncoding == HashingEncoding.BASE32 ? new EncodingService().encodeToBase32(digestBytes) : new EncodingService().encodeToBase64(digestBytes));
        return encoded;
    }
}

