/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.importscript.data.excel;

import com.constellio.plugin050.importscript.data.batchImport.ImportDataIterator;
import com.constellio.plugin050.importscript.data.batchImport.ImportDataIteratorRuntimeException;
import com.constellio.plugin050.importscript.data.batchImport.ImportDataProvider;
import com.constellio.plugin050.importscript.data.batchImport.ImportDataProviderRuntimeException;
import com.constellio.plugin050.importscript.data.excel.Excel2007Sheet;
import com.constellio.plugin050.importscript.data.excel.ExcelImportDataIterator;
import com.constellio.plugin050.importscript.data.excel.ExcelSheet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class Excel2007ImportDataProvider
implements ImportDataProvider {
    private File excelFile;
    private OPCPackage opcPackage;
    private XSSFWorkbook workbook;

    public Excel2007ImportDataProvider(File excelFile) {
        this.excelFile = excelFile;
    }

    @Override
    public int size(String schemaType) {
        int count = 0;
        ImportDataIterator iterator = this.newDataIterator(schemaType);
        try {
            while (iterator.hasNext()) {
                iterator.next();
                ++count;
            }
        }
        catch (RuntimeException e) {
            if (e instanceof ImportDataIteratorRuntimeException.ImportDataIteratorRuntimeException_InvalidDate) {
                ImportDataIteratorRuntimeException.ImportDataIteratorRuntimeException_InvalidDate exception = (ImportDataIteratorRuntimeException.ImportDataIteratorRuntimeException_InvalidDate)e;
                throw new ImportDataProviderRuntimeException.ImportDataProviderRuntimeException_InvalidDate(exception.getDateFormat(), exception.getInvalidValue());
            }
            throw new ImportDataProviderRuntimeException(e);
        }
        return count;
    }

    @Override
    public void initialize() {
        this.workbook = this.loadWorkbook(this.excelFile);
    }

    @Override
    public void close() {
        try {
            this.opcPackage.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<String> getAvailableSchemaTypes() {
        ArrayList<String> sheetNames = new ArrayList<String>();
        Iterator<Sheet> iterator = this.workbook.iterator();
        while (iterator.hasNext()) {
            sheetNames.add(iterator.next().getSheetName());
        }
        return sheetNames;
    }

    @Override
    public ImportDataIterator newDataIterator(String schemaType) {
        if (this.getAvailableSchemaTypes().contains(schemaType)) {
            return new ExcelImportDataIterator(this.getExcelSheet(schemaType));
        }
        throw new RuntimeException("There are no sheet with this schema type");
    }

    public XSSFWorkbook loadWorkbook(File workbookFile) {
        try {
            this.opcPackage = OPCPackage.open(new FileInputStream(workbookFile));
            return new XSSFWorkbook(this.opcPackage);
        }
        catch (IOException | InvalidFormatException e) {
            throw new RuntimeException(e);
        }
    }

    public static Excel2007ImportDataProvider fromFile(File excelFile) {
        Excel2007ImportDataProvider instance = new Excel2007ImportDataProvider(excelFile);
        instance.initialize();
        return instance;
    }

    public ExcelSheet getExcelSheet(String schemaType) {
        return new Excel2007Sheet(this.workbook.getSheet(schemaType));
    }
}

