/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.importscript.data.batchImport;

import com.constellio.plugin050.exception.NbTriesExceededException;
import com.constellio.plugin050.importscript.HttpConfigurations;
import com.constellio.plugin050.importscript.data.batchImport.BatchImportConnection;
import com.constellio.plugin050.importscript.data.batchImport.NoSuchRecordException;
import com.constellio.plugin050.importscript.exceptions.BatchImportSocketConstellioServicesRuntimeException;
import com.constellio.plugin050.importscript.exceptions.ServerUnavailableException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ContextedRuntimeException;

public class BatchImportSocketConstellioServices {
    private BatchImportConnection connection;
    private HttpConfigurations configs;
    public static final String COLLECTION = "collection";
    public static final String USERNAME = "username";
    public static final String TOKEN_OR_PASSWORD = "token";
    public static final String SERVICEKEY = "serviceKey";
    public static final int NB_CALL_TRIES = 3;

    public BatchImportSocketConstellioServices(BatchImportConnection connection, HttpConfigurations configs) {
        this.connection = connection;
        this.configs = configs;
    }

    private <T> T callService(String servletPath, Map<String, Object> inParams, boolean timeout, int nbTries) throws NbTriesExceededException {
        for (int currentTry = 0; currentTry < nbTries; ++currentTry) {
            try {
                return this.sendRequest(servletPath, inParams, timeout);
            }
            catch (Exception e) {
                System.out.print(e.getMessage());
                continue;
            }
        }
        throw new NbTriesExceededException("Number of tries exceeded for call.");
    }

    private <T> T sendRequest(String servletPath, Map<String, Object> inParams, boolean timeout) {
        String throwableStackTrace;
        String throwableMessage;
        String throwableClassName;
        InputStream input;
        OutputStream output;
        HttpURLConnection outConnection;
        block19: {
            String baseURL = this.connection.getUrl();
            if (this.connection.getUrl() == null) {
                throw new ServerUnavailableException();
            }
            outConnection = null;
            output = null;
            input = null;
            outConnection = this.setupOutConnection(baseURL, servletPath, timeout);
            String bearerToken = "Bearer " + this.configs.getRefreshableTokenValue();
            outConnection.setRequestProperty("Authorization", bearerToken);
            if ("/uploadContentInVault".equals(servletPath)) {
                this.setUploadContentConnectionParams(outConnection, inParams);
                output = outConnection.getOutputStream();
                fileToSend = new File((String)inParams.get("fileAbsolutePath"));
                fileInputStream = new FileInputStream(fileToSend);
                IOUtils.copy((InputStream)fileInputStream, output);
            } else if ("/uploadRecords".equals(servletPath)) {
                this.setUploadRecordConnectionParams(outConnection, inParams);
                fileToSend = new File((String)inParams.get("importFile"));
                output = outConnection.getOutputStream();
                fileInputStream = new FileInputStream(fileToSend);
                try {
                    IOUtils.copy((InputStream)fileInputStream, output);
                }
                finally {
                    fileInputStream.close();
                }
            } else {
                inParams.put(USERNAME, this.connection.getUsername());
                inParams.put(COLLECTION, this.connection.getCollection());
                inParams.put(TOKEN_OR_PASSWORD, this.connection.getToken().getBytes(Charset.forName("UTF-8")));
                outConnection.setDoOutput(true);
                output = outConnection.getOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(output);
                oos.writeObject(inParams);
            }
            input = outConnection.getInputStream();
            ObjectInputStream ois = new ObjectInputStream(input);
            Map deserialized = (Map)ois.readObject();
            Object result = deserialized.get("result");
            throwableClassName = (String)deserialized.get("throwableClassName");
            throwableMessage = (String)deserialized.get("throwableMessage");
            throwableStackTrace = (String)deserialized.get("throwableStackTrace");
            if (throwableClassName != null) break block19;
            Object v = result;
            IOUtils.closeQuietly(input);
            IOUtils.closeQuietly(output);
            IOUtils.close(outConnection);
            return (T)v;
        }
        try {
            try {
                ContextedRuntimeException contextedRuntimeException = new ContextedRuntimeException(throwableMessage);
                contextedRuntimeException.addContextValue("className", throwableClassName);
                contextedRuntimeException.addContextValue("stackTrace", throwableStackTrace);
                throw contextedRuntimeException;
            }
            catch (Throwable t2) {
                t2.printStackTrace();
                if (t2.getMessage() != null && t2.getMessage().contains("401")) {
                    throw new BatchImportSocketConstellioServicesRuntimeException.BatchImportSocketConstellioServicesRuntimeException_UnauthorizedAccess();
                }
                if (t2 instanceof ContextedRuntimeException) {
                    ContextedRuntimeException contextedRuntimeException = (ContextedRuntimeException)t2;
                    String message = contextedRuntimeException.getRawMessage();
                    String className = (String)contextedRuntimeException.getFirstContextValue("className");
                    if (className.startsWith("com.constellio.model.services.records.RecordServicesRuntimeException")) {
                        throw new NoSuchRecordException(message);
                    }
                    throw contextedRuntimeException;
                }
                if (t2 instanceof ConnectException) {
                    throw new ServerUnavailableException(t2);
                }
                throw new RuntimeException(t2);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            IOUtils.closeQuietly(output);
            IOUtils.close(outConnection);
            throw throwable;
        }
    }

    private HttpURLConnection setupOutConnection(String baseURL, String servletPath, boolean timeout) throws MalformedURLException {
        HttpURLConnection outConnection;
        if (!((String)baseURL).endsWith("/")) {
            baseURL = (String)baseURL + "/";
        }
        baseURL = (String)baseURL + "rm";
        URL serviceURL = new URL((String)baseURL + servletPath);
        try {
            outConnection = (HttpURLConnection)serviceURL.openConnection();
        }
        catch (Throwable t2) {
            t2.printStackTrace();
            throw new ServerUnavailableException(t2);
        }
        if (timeout) {
            outConnection.setConnectTimeout(300000);
            outConnection.setReadTimeout(300000);
        }
        return outConnection;
    }

    private void setUploadContentConnectionParams(HttpURLConnection outConnection, Map<String, Object> params) throws IOException {
        outConnection.setRequestMethod("POST");
        outConnection.setDoInput(true);
        outConnection.setDoOutput(true);
        outConnection.setUseCaches(false);
        outConnection.setDefaultUseCaches(false);
        outConnection.addRequestProperty("fileName", (String)params.get("fileName"));
        outConnection.addRequestProperty(USERNAME, this.connection.getUsername());
        outConnection.addRequestProperty(TOKEN_OR_PASSWORD, this.connection.getToken());
        outConnection.addRequestProperty(SERVICEKEY, this.connection.getServiceKey());
        int bufferSize = 0x100000;
        outConnection.setChunkedStreamingMode(0x100000);
        outConnection.connect();
    }

    private void setUploadRecordConnectionParams(HttpURLConnection outConnection, Map<String, Object> params) throws IOException {
        outConnection.setRequestMethod("POST");
        outConnection.setDoInput(true);
        outConnection.setDoOutput(true);
        outConnection.setUseCaches(false);
        outConnection.setDefaultUseCaches(false);
        outConnection.addRequestProperty("dataType", (String)params.get("dataType"));
        outConnection.addRequestProperty(USERNAME, this.connection.getUsername());
        outConnection.addRequestProperty(TOKEN_OR_PASSWORD, this.connection.getToken());
        outConnection.addRequestProperty(COLLECTION, this.connection.getCollection());
        outConnection.addRequestProperty(SERVICEKEY, this.connection.getServiceKey());
        outConnection.setDoOutput(true);
        int bufferSize = 0x100000;
        outConnection.setChunkedStreamingMode(0x100000);
        outConnection.connect();
    }

    public String uploadContentInVault(String fileAbsolutePath, String fileName, String progression, boolean timeout) {
        HashMap<String, Object> inParams = new HashMap<String, Object>();
        inParams.put("fileAbsolutePath", fileAbsolutePath);
        inParams.put("fileName", fileName);
        try {
            Map hashResponse = (Map)this.callService("/uploadContentInVault", inParams, timeout, 3);
            System.out.println(progression + fileAbsolutePath);
            return (String)hashResponse.get("hash");
        }
        catch (Exception e) {
            Scanner input = new Scanner(System.in);
            System.out.println("\u001b[31mErreur lors du t\u00e9l\u00e9versement des fichiers.");
            System.out.println("\u001b[31mAssurez-vous que votre version de Constellio est compatible avec cette version du client d'importation  puis red\u00e9marrez le client d'importation.");
            System.out.println(e.getMessage());
            e.printStackTrace();
            input.next();
            System.exit(0);
            return null;
        }
    }
}

