/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.importscript;

import com.constellio.plugin050.importscript.CellContent;
import com.constellio.plugin050.importscript.ClientLogWriter;
import com.constellio.plugin050.importscript.HttpConfigurations;
import com.constellio.plugin050.importscript.RecordImportServices;
import com.constellio.plugin050.importscript.data.batchImport.BatchImportConnection;
import com.constellio.plugin050.importscript.data.batchImport.BatchImportSocketConstellioServices;
import com.constellio.plugin050.importscript.data.batchImport.ImportData;
import com.constellio.plugin050.importscript.data.batchImport.ImportDataIterator;
import com.constellio.plugin050.importscript.data.excel.Excel2007ImportDataProvider;
import com.constellio.plugin050.importscript.data.excel.ExcelCell;
import com.constellio.plugin050.importscript.data.excel.ExcelSheet;
import com.constellio.plugin050.importscript.data.util.HashingEncoding;
import com.constellio.plugin050.importscript.data.util.HashingService;
import com.constellio.plugin050.importscript.exceptions.HashingServiceException;
import com.constellio.plugin050.util.ImportConfigurationsManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelFileImporter {
    private static final String FILE_SUFFIX_IMPORTABLE = "importable";
    private static final String FILE_SUFFIX_VALIDATION = "validation";
    private String DOCUMENT_SCHEMA_TYPE = "document";
    private static final String OUTPUT_FOLDER_PROPERTY = "import.outputPath";
    public static final String DEFAULT_FILE = "template.xlsx";
    protected static final String LOG_FILE_NAME = "log.txt";
    public static final String DEFAULT_PATH = "";
    private static final String CONTENT_COLUMN_TITLE = "content";
    private HttpConfigurations systemConfig;
    private String IMPORT_SUCCESS_RESPONSE = "SUCCESS";
    private static final long RETRY_FILE_SLEEP_TIME = 500L;
    private static final int NB_RETRY_NOT_FOUND_FILES = 3;
    private HashMap<String, String> skippedContents;
    private static final HashMap<String, String> alreadyUploadedMap = new HashMap();
    private static boolean alreadyUploadedFlag = false;
    private FileWriter alreadyUploadedFile = null;
    private String filePath;
    private ImportConfigurationsManager importConfigurationsManager;

    public ExcelFileImporter(HttpConfigurations config) {
        this.systemConfig = config;
        File importConfigurations = new File("configurations/exportImport.properties");
        this.importConfigurationsManager = new ImportConfigurationsManager(importConfigurations);
        this.filePath = this.importConfigurationsManager.readProperty("import.filePath");
        this.skippedContents = new HashMap();
    }

    public ExcelFileImporter(HttpConfigurations config, HashMap<String, String> skippedContents) {
        this.systemConfig = config;
        File importConfigurations = new File("configurations/exportImport.properties");
        this.importConfigurationsManager = new ImportConfigurationsManager(importConfigurations);
        String configPath = this.importConfigurationsManager.readProperty("import.filePath");
        this.filePath = configPath == null ? "data/template.xlsx" : configPath;
        this.skippedContents = skippedContents == null ? new HashMap() : skippedContents;
    }

    private BatchImportConnection getConnection() {
        BatchImportConnection connection = new BatchImportConnection();
        connection.setToken(this.systemConfig.getRefreshableTokenValue());
        connection.setUrl(this.systemConfig.getServerUrl().toString());
        connection.setUsername(this.systemConfig.getUsername());
        connection.setCollection(this.systemConfig.getCollection());
        connection.setServiceKey(this.systemConfig.getServiceKey());
        return connection;
    }

    public String getImportFilePath() {
        return this.filePath;
    }

    public List<CellContent> uploadContent() {
        List<CellContent> filesToUpload = this.getContentsToUpload(new File(this.filePath));
        if (filesToUpload == null) {
            return null;
        }
        ArrayList<CellContent> uploadedContent = new ArrayList<CellContent>();
        BatchImportSocketConstellioServices importServices = new BatchImportSocketConstellioServices(this.getConnection(), this.systemConfig);
        System.out.println("Importation du contenu des documents...");
        int i = 0;
        for (CellContent cell : filesToUpload) {
            String filePath = cell.getCellValue();
            if (filePath != null) {
                File file = new File(filePath);
                String progressionString = this.generateProgressionString(i, filesToUpload.size());
                boolean uploadInVault = !this.systemConfig.isSkipMissingFiles() || file.exists();
                String hash = DEFAULT_PATH;
                if (uploadInVault) {
                    if (alreadyUploadedFlag) {
                        String clientImportHash = this.getImportClientHashString(file);
                        if (this.checkFileAgainstAlreadyUploaded(clientImportHash)) {
                            hash = clientImportHash;
                            System.out.println(progressionString + "\u001b[33mD\u00e9j\u00e0 t\u00e9l\u00e9vers\u00e9,  " + filePath + "\u001b[0m");
                        } else {
                            hash = importServices.uploadContentInVault(filePath, file.getName(), progressionString, this.systemConfig.isWithConnectionTimeout());
                            this.addInfosToAlreadyUploadedFile(filePath, hash);
                        }
                    } else {
                        hash = importServices.uploadContentInVault(filePath, file.getName(), progressionString, this.systemConfig.isWithConnectionTimeout());
                        this.addInfosToAlreadyUploadedFile(filePath, hash);
                    }
                }
                uploadedContent.add(new CellContent(cell.getX(), cell.getY(), hash));
            }
            ++i;
        }
        return uploadedContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInfosToAlreadyUploadedFile(String filePath, String vaultHash) {
        String serverHostName = this.systemConfig.getServerUrl().getHost();
        String alreadyUploadedFilePath = "data/Recuperation." + serverHostName;
        try {
            if (this.alreadyUploadedFile == null) {
                this.alreadyUploadedFile = new FileWriter(alreadyUploadedFilePath, true);
            }
            this.alreadyUploadedFile.write(vaultHash + "|@" + filePath + "||@\r\n");
            this.alreadyUploadedFile.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("\u001b[31mCould not save progression for upload resume.\u001b[0m");
            this.alreadyUploadedFile = null;
        }
        finally {
            try {
                this.alreadyUploadedFile.close();
            }
            catch (Exception exception) {}
            this.alreadyUploadedFile = null;
        }
    }

    private boolean checkFileAgainstAlreadyUploaded(String clientImportHash) {
        if (!clientImportHash.isEmpty()) {
            return alreadyUploadedMap.containsKey(clientImportHash);
        }
        return false;
    }

    private String getImportClientHashString(File fileToGetHash) {
        HashingService hashingService = HashingService.forSHA1(null, HashingEncoding.BASE64_URL_ENCODED);
        String result = DEFAULT_PATH;
        try {
            result = hashingService.getHashFromFile(fileToGetHash);
        }
        catch (HashingServiceException e) {
            e.printStackTrace();
        }
        return result;
    }

    private String generateProgressionString(int index, int size) {
        StringBuilder sb = new StringBuilder().append("\u001b[34m").append("[").append(index + 1).append("/").append(size).append("]").append(" \t").append("\u001b[0m");
        return sb.toString();
    }

    public void uploadExcelFile(String path) {
        RecordImportServices importServices = new RecordImportServices(this.systemConfig);
        String response = importServices.uploadXLSXFile(path);
        if (response == null) {
            System.out.println("\u001b[31mAucune r\u00e9ponse du serveur...\u001b[0m");
        } else if (response.contains(this.IMPORT_SUCCESS_RESPONSE)) {
            String serverHostName;
            String alreadyUploadedFilePath;
            File alreadyUploadedFile;
            System.out.println("\u001b[32mLes enregistrements ont \u00e9t\u00e9 import\u00e9s avec succ\u00e8s\u001b[0m");
            if (this.skippedContents.size() > 0) {
                ClientLogWriter logWriter = new ClientLogWriter("data/log.txt");
                logWriter.writeSkippedContentsToLogFile(this.skippedContents);
            }
            if ((alreadyUploadedFile = new File(alreadyUploadedFilePath = "data/Recuperation." + (serverHostName = this.systemConfig.getServerUrl().getHost()))).exists()) {
                this.deleteFile(alreadyUploadedFilePath);
            }
        } else {
            System.out.println("\u001b[33mDes erreurs sont survenues lors de l'importation:\u001b[0m");
            System.out.println("\u001b[31m" + response + "\u001b[0m");
            ClientLogWriter logWriter = new ClientLogWriter("data/log.txt");
            logWriter.writeMessageToLogFile(response);
        }
        this.deleteFile(this.getImportableFilePath());
    }

    public boolean validateExcelFile(String tempFilePath) {
        RecordImportServices importServices = new RecordImportServices(this.systemConfig);
        String response = importServices.validateXLSXFile(tempFilePath);
        if (response == null) {
            System.out.println("\u001b[31mAucune r\u00e9ponse du serveur...\u001b[0m");
        } else {
            if (response.contains(this.IMPORT_SUCCESS_RESPONSE)) {
                this.deleteFile(tempFilePath);
                return true;
            }
            System.out.println(String.format("\u001b[33mDes erreurs de validation sont survenues, veuillez consulter le fichier %s pour plus de d\u00e9tails.\u001b[0m", LOG_FILE_NAME));
            System.out.println("\u001b[31m" + response + "\u001b[0m");
            ClientLogWriter logWriter = new ClientLogWriter("data/log.txt");
            logWriter.writeMessageToLogFile(response);
        }
        this.deleteFile(tempFilePath);
        return false;
    }

    private void deleteFile(String path) {
        File file = new File(path);
        file.delete();
    }

    private List<CellContent> getContentsToUpload(File file) {
        System.out.println(String.format("Lecture du fichier %s", file.getName()));
        ArrayList<CellContent> contentList = new ArrayList<CellContent>();
        try {
            Excel2007ImportDataProvider importDataProvider = new Excel2007ImportDataProvider(file);
            importDataProvider.initialize();
            Integer contentColumnPos = this.getContentColumnPosition(importDataProvider);
            if (contentColumnPos != null) {
                ImportDataIterator iterator = importDataProvider.newDataIterator(this.DOCUMENT_SCHEMA_TYPE);
                while (iterator.hasNext()) {
                    ImportData importData = (ImportData)iterator.next();
                    String content = (String)importData.getFields().get(CONTENT_COLUMN_TITLE);
                    int posX = contentColumnPos == null ? importData.getFields().size() : contentColumnPos.intValue();
                    int posY = importData.getIndex();
                    if (this.validateFileExists(content, 3, importData.getLegacyId()) || this.systemConfig.isSkipMissingFiles()) {
                        contentList.add(new CellContent(posX, posY, content));
                        continue;
                    }
                    System.out.println(String.format("\u001b[31mFichier manquant \u00e0 la ligne %d\u001b[0m", posY));
                    return null;
                }
            }
        }
        catch (Exception e) {
            System.out.println(String.format("\u001b[31mImpossible de lire le fichier '%s' V\u00e9rifiez le fichier de configuration.\u001b[0m", file));
        }
        return contentList;
    }

    private boolean validateFileExists(String filePath, int nbTriesLeft, String id) {
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                if (nbTriesLeft > 0) {
                    System.out.println(String.format("\u001b[31m\tFichier '%s' non-trouv\u00e9. Nouvel essai.\u001b[0m", filePath));
                    Thread.sleep(500L);
                    return this.validateFileExists(filePath, nbTriesLeft - 1, id);
                }
                System.out.println(String.format("\u001b[31mLe fichier r\u00e9f\u00e9renc\u00e9 '%s' n'existe pas\u001b[0m", filePath));
                this.skippedContents.put(id, filePath);
                return false;
            }
        }
        catch (InterruptedException | NullPointerException e) {
            e.printStackTrace();
            return false;
        }
        if (nbTriesLeft < 3) {
            System.out.println(String.format("\u001b[32m\tFichier '%s' trouv\u00e9\u001b[0m", filePath));
        }
        return true;
    }

    private Integer getContentColumnPosition(Excel2007ImportDataProvider importDataProvider) {
        try {
            ExcelSheet sheet = importDataProvider.getExcelSheet(this.DOCUMENT_SCHEMA_TYPE);
            for (int i = 0; i <= sheet.getRows(); ++i) {
                int x = 0;
                for (ExcelCell cell : sheet.getRow(i)) {
                    if (cell.getContents().equals(CONTENT_COLUMN_TITLE)) {
                        return x;
                    }
                    ++x;
                }
            }
        }
        catch (Exception e) {
            System.out.println("\u001b[31mLe fichier Excel n'a pas de page 'document'\u001b[0m");
            ClientLogWriter logWriter = new ClientLogWriter("data/log.txt");
            logWriter.writeMessageToLogFile("\u001b[31mLe fichier Excel n'a pas de page 'document'\u001b[0m");
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return null;
    }

    private void deleteNonDocumentSheets(Workbook workbook) {
        Iterator<Sheet> sheetIterator = workbook.sheetIterator();
        int i = 0;
        while (sheetIterator.hasNext()) {
            Sheet sheet = sheetIterator.next();
            if (sheet.getSheetName() != this.DOCUMENT_SCHEMA_TYPE) {
                workbook.removeSheetAt(i);
            }
            ++i;
        }
    }

    private String getValidationFilePath() {
        return this.generateTemplateCopyName(FILE_SUFFIX_VALIDATION);
    }

    private String getImportableFilePath() {
        return this.generateTemplateCopyName(FILE_SUFFIX_IMPORTABLE);
    }

    public File createValidationFile() throws FileNotFoundException {
        File originalFile = new File(this.filePath);
        String validationFilePath = this.getValidationFilePath();
        try {
            FileInputStream inputStream = new FileInputStream(originalFile);
            Workbook workbook = WorkbookFactory.create(inputStream);
            Sheet sheet = workbook.getSheet(this.DOCUMENT_SCHEMA_TYPE);
            Row headerRow = sheet.getRow(1);
            int contentFilePathColumn = -1;
            for (int i = 0; i <= headerRow.getPhysicalNumberOfCells() - 1; ++i) {
                Cell cell = headerRow.getCell(i);
                if (cell == null || !cell.getStringCellValue().startsWith(CONTENT_COLUMN_TITLE)) continue;
                cell.setCellValue(DEFAULT_PATH);
                contentFilePathColumn = i;
                break;
            }
            if (contentFilePathColumn > -1) {
                for (Row row : sheet) {
                    Cell cell = row.getCell(contentFilePathColumn);
                    if (cell == null) continue;
                    row.removeCell(row.getCell(contentFilePathColumn));
                }
            }
            FileOutputStream fileOut = new FileOutputStream(validationFilePath);
            workbook.write(fileOut);
            workbook.close();
            fileOut.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new File(validationFilePath);
    }

    private String generateTemplateCopyName(String suffix) {
        StringBuilder newFilePathBuilder = new StringBuilder();
        newFilePathBuilder.append(FilenameUtils.getFullPath(this.filePath)).append(FilenameUtils.getBaseName(this.filePath)).append(".").append(suffix).append(".").append(FilenameUtils.getExtension(this.filePath));
        return newFilePathBuilder.toString();
    }

    public String writeImportableFile(List<CellContent> imported) {
        File originalFile = new File(this.filePath);
        String importableFilePath = this.getImportableFilePath();
        try {
            FileInputStream inputStream = new FileInputStream(originalFile);
            Workbook workbook = WorkbookFactory.create(inputStream);
            Sheet sheet = workbook.getSheet(this.DOCUMENT_SCHEMA_TYPE);
            this.deleteBlankRows(sheet);
            if (imported.size() > 0) {
                int contentColumn = imported.get(0).getX();
                Cell headerCell = sheet.getRow(1).getCell(contentColumn);
                headerCell.setCellValue("content\ntype=filename:hash");
            }
            for (CellContent content : imported) {
                Cell cell;
                Row row = sheet.getRow(content.getY());
                if (row == null || (cell = sheet.getRow(content.getY()).getCell(content.getX())) == null) continue;
                String filePath = cell.getStringCellValue();
                File tempFile = new File(filePath);
                String filename = tempFile.getName();
                String hash = content.getCellValue();
                if (StringUtils.isNotBlank(hash)) {
                    cell.setCellValue(filename + ":" + hash);
                    continue;
                }
                cell.setCellValue(DEFAULT_PATH);
            }
            FileOutputStream fileOut = new FileOutputStream(importableFilePath);
            workbook.write(fileOut);
            workbook.close();
            fileOut.close();
        }
        catch (IOException e) {
            System.out.print("\u001b[31m\nImpossible de cr\u00e9er une copie du fichier Excel.\nAssurez-vous que le fichier n'est pas ouvert dans un autre programme.\u001b[0m");
            e.printStackTrace();
            return null;
        }
        return importableFilePath;
    }

    private void deleteBlankRows(Sheet sheet) {
        boolean nonEmptyRowFound = false;
        block0: while (!nonEmptyRowFound) {
            Row lastRow = sheet.getRow(sheet.getLastRowNum());
            for (int i = lastRow.getFirstCellNum(); i <= lastRow.getLastCellNum(); ++i) {
                if (!lastRow.getCell(i).getCellType().equals((Object)CellType.BLANK)) {
                    nonEmptyRowFound = true;
                    continue block0;
                }
                sheet.removeRow(lastRow);
            }
        }
    }

    public HashMap<String, String> getSkippedContents() {
        return this.skippedContents;
    }

    public void readAlreadyUploadedFile() {
        String serverHostName = this.systemConfig.getServerUrl().getHost();
        String alreadyUploadedFilePath = "data/Recuperation." + serverHostName;
        File alreadyUploadedFile = new File(alreadyUploadedFilePath);
        alreadyUploadedFlag = false;
        alreadyUploadedMap.clear();
        if (alreadyUploadedFile.exists()) {
            alreadyUploadedFlag = true;
            try (BufferedReader br = new BufferedReader(Files.newBufferedReader(Paths.get(alreadyUploadedFilePath, new String[0]), Charset.forName("utf-8")));){
                String line;
                while ((line = br.readLine()) != null) {
                    String importClientHash = line.substring(0, line.indexOf("|@"));
                    String uploadedFilePath = line.substring(line.indexOf("|@") + 2, line.indexOf("||@"));
                    alreadyUploadedMap.putIfAbsent(importClientHash, uploadedFilePath);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

