/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.importscript;

import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Map;

public class ClientLogWriter {
    private String filename;

    public ClientLogWriter(String filename) {
        this.filename = filename;
        System.out.println("Consultez le log d'erreur pour plus de d\u00e9tails: " + filename);
    }

    public void writeMessageToLogFile(String value) {
        try {
            FileWriter writer = new FileWriter(this.filename, true);
            StringBuilder builder = new StringBuilder();
            builder.append("\n").append(LocalDateTime.now().toString()).append(": ").append(value).append("\n");
            writer.write(builder.toString());
            writer.flush();
        }
        catch (IOException e) {
            System.out.println("\n");
            System.out.println(LocalDateTime.now().toString());
            System.out.println(value);
            System.out.println("Impossible d'\u00e9crire dans un nouveau fichier de log");
            System.out.println("Consultez les logs du serveur pour plus d'information.");
        }
    }

    public void writeSkippedContentsToLogFile(Map<String, String> skippedContents) {
        try {
            FileWriter writer = new FileWriter(this.filename, true);
            writer.write("Documents dont le contenu n'a pas \u00e9t\u00e9 import\u00e9:\n");
            writer.write("-----------------------------------------------\n");
            for (String key : skippedContents.keySet()) {
                String message = String.format("Document %s : %s\n", key, skippedContents.get(key));
                writer.write(message);
            }
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

