/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.auth.webSignIn.duplex.signin.result;

import com.constellio.plugin050.auth.webSignIn.duplex.signin.DuplexSignInContext;
import com.constellio.plugin050.auth.webSignIn.duplex.signin.DuplexSignInResult;
import com.constellio.plugin050.auth.webSignIn.duplex.signin.result.WaitingForDuplexSignInResultContext;
import com.constellio.plugin050.auth.webSignIn.duplex.signin.result.dto.DuplexSignInResultFailDTO;
import com.constellio.plugin050.auth.webSignIn.duplex.signin.result.dto.DuplexSignInResultSuccessDTO;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;

@Path(value="/auth")
public class WaitingForDuplexSignInResultServlet {
    public static final String DUPLEX_SIGN_IN_CONTEXT_PROPERTY_NAME = "WaitingForDuplexSignInResultServlet_duplexSignInContext";
    @Context
    Configuration configuration;

    @POST
    @Consumes(value={"application/json"})
    public Response completeAuthentication(DuplexSignInResultSuccessDTO updateAuthenticationDTO) {
        Object context = this.configuration.getProperty(DUPLEX_SIGN_IN_CONTEXT_PROPERTY_NAME);
        if (context instanceof WaitingForDuplexSignInResultContext) {
            return this.handleCompleteAuthentication((WaitingForDuplexSignInResultContext)context, updateAuthenticationDTO);
        }
        throw new RuntimeException("An error has occured while starting  the server");
    }

    @POST
    @Path(value="/error")
    @Consumes(value={"application/json"})
    public Response failAuthentication(DuplexSignInResultFailDTO duplexSignInResultFailDto) {
        Object context = this.configuration.getProperty(DUPLEX_SIGN_IN_CONTEXT_PROPERTY_NAME);
        if (context instanceof WaitingForDuplexSignInResultContext) {
            return this.handleFailAuthentication((WaitingForDuplexSignInResultContext)context, duplexSignInResultFailDto);
        }
        throw new RuntimeException("An error has occured while starting  the server");
    }

    private Response handleCompleteAuthentication(WaitingForDuplexSignInResultContext context, final DuplexSignInResultSuccessDTO duplexSignInResultSuccessDTO) {
        DuplexSignInContext webSignInContext = context.getDuplexSignInContext();
        String authenticationId = webSignInContext.getAuthenticationId();
        if (!StringUtils.equals(authenticationId, duplexSignInResultSuccessDTO.getAuthenticationContextKey())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        if (StringUtils.isBlank(duplexSignInResultSuccessDTO.getServiceKey()) && StringUtils.isBlank(duplexSignInResultSuccessDTO.getServiceKey())) {
            return Response.status(Response.Status.BAD_REQUEST).build();
        }
        context.completeAuthentication(new DuplexSignInResult(duplexSignInResultSuccessDTO.getUsername(), duplexSignInResultSuccessDTO.getServiceKey(), duplexSignInResultSuccessDTO.getCollection(), duplexSignInResultSuccessDTO.getAccessToken(), duplexSignInResultSuccessDTO.getAuthCode()){

            @Override
            public String getRefreshToken() {
                return duplexSignInResultSuccessDTO.getRefreshToken();
            }
        });
        return Response.ok().build();
    }

    private Response handleFailAuthentication(WaitingForDuplexSignInResultContext context, DuplexSignInResultFailDTO localSignInResultFailDto) {
        DuplexSignInContext duplexSignInContext = context.getDuplexSignInContext();
        String authenticationId = duplexSignInContext.getAuthenticationId();
        if (!StringUtils.equals(authenticationId, localSignInResultFailDto.getAuthenticationContextKey())) {
            return Response.status(Response.Status.UNAUTHORIZED).build();
        }
        context.failAuthentication(localSignInResultFailDto.getError());
        return Response.ok().build();
    }

    public static void configureProperties(BiConsumer<String, Object> configure, WaitingForDuplexSignInResultContext context) {
        configure.accept(DUPLEX_SIGN_IN_CONTEXT_PROPERTY_NAME, context);
    }
}

