/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.auth.webSignIn;

import com.constellio.plugin050.auth.webSignIn.OSServices;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class OSServicesImpl
implements OSServices {
    @Override
    public String getOpenCommand(String extension, String filePath) {
        String openCommand = SystemUtils.IS_OS_WINDOWS ? this.getWindowsOpenCommand(extension, filePath) : (SystemUtils.IS_OS_LINUX ? this.getLinuxOpenCommand(extension, filePath) : (SystemUtils.IS_OS_MAC ? this.getMacOpenCommand(extension, filePath) : null));
        return openCommand;
    }

    @Override
    public void runCommand(String command) {
        if (StringUtils.isNotBlank(command)) {
            try {
                this.executeCommand(command);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Process executeCommand(String command) throws IOException {
        Process process;
        if (SystemUtils.IS_OS_WINDOWS) {
            process = Runtime.getRuntime().exec(command);
        } else {
            String[] arguments = new String[]{"/bin/sh", "-c", command};
            process = Runtime.getRuntime().exec(arguments);
        }
        return process;
    }

    String getWindowsOpenCommand(String extension, String filePath) {
        String launchExePath = "rundll32 url.dll,FileProtocolHandler";
        return launchExePath + " \"" + filePath + "\"";
    }

    String getLinuxOpenCommand(String extension, String filePath) {
        return "xdg-open \"" + filePath + "\"";
    }

    String getMacOpenCommand(String extension, String filePath) {
        return "open \"" + filePath + "\"";
    }
}

