/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.auth;

import com.constellio.plugin050.importscript.HttpConfigurations;
import com.constellio.plugin050.importscript.data.util.TimeProvider;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.Response;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.json.JSONObject;

public class RefreshableAccessToken {
    private static final int MAX_RETRIES = 3;
    private final HttpConfigurations config;
    private String value;
    private Date expirationDate;

    public RefreshableAccessToken(HttpConfigurations config) {
        this.config = config;
    }

    public String getValidValue() {
        if (this.hasToBeRefreshed()) {
            this.refreshToken();
        }
        return this.value;
    }

    private void refreshToken() {
        int retryCount = 0;
        while (retryCount < 3) {
            Response response = this.refreshTokenCall();
            int status = response.getStatus();
            if (status == 200) {
                this.setNewTokenInConfig(response);
                return;
            }
            if (++retryCount != 3) continue;
            String errorResponse = response.readEntity(String.class);
            throw new TokenRefreshException(status, errorResponse);
        }
    }

    private void setNewTokenInConfig(Response response) {
        JSONObject jsonObject = new JSONObject(response.readEntity(String.class));
        String accessToken = jsonObject.getString("access_token");
        int expiresInSeconds = jsonObject.getInt("expires_in");
        Date expirationDate = new Date(RefreshableAccessToken.toDate(TimeProvider.getLocalDateTime()).getTime() + (long)(expiresInSeconds * 1000));
        this.config.setRefreshableTokenValue(accessToken);
        this.config.setExpirationDate(expirationDate);
    }

    private Response refreshTokenCall() {
        Form form = new Form().param("grant_type", "refresh_token").param("client_id", this.config.getOauth2ClientId()).param("client_secret", this.config.getOauth2ClientSecret()).param("refresh_token", this.config.getRefreshToken());
        Client client = ClientBuilder.newClient();
        WebTarget webTarget = client.target(this.config.getServerUrl() + "/oauth/v2/token");
        Response response = webTarget.request().post(Entity.form(form));
        return response;
    }

    private boolean hasToBeRefreshed() {
        return this.config.isAuthenticateWithOauth2() && this.isCloseToExpiration();
    }

    private boolean isCloseToExpiration() {
        int ONE_MINUTE = 60000;
        Date expiration = new Date(this.expirationDate.getTime() - (long)ONE_MINUTE);
        Date now = new Date(RefreshableAccessToken.toDate(TimeProvider.getLocalDateTime()).getTime());
        return now.after(expiration);
    }

    private static Date toDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public static class TokenRefreshException
    extends RuntimeException {
        private final String message;

        public TokenRefreshException(int status, String errorResponse) {
            this.message = "Refreshing Token failed after 3 Tries. Received unexpected status: " + status + ", with body:\n" + errorResponse;
            System.err.print(this.message);
            this.printStackTrace();
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }
}

