/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050;

import com.constellio.plugin050.auth.ImportClientLegacyAuthentificationManager;
import com.constellio.plugin050.auth.webSignIn.DuplexAuthenticationServices;
import com.constellio.plugin050.auth.webSignIn.WebSignInResponse;
import com.constellio.plugin050.auth.webSignIn.duplex.AuthenticationType;
import com.constellio.plugin050.importscript.ClientLogWriter;
import com.constellio.plugin050.importscript.HttpConfigurations;
import com.constellio.plugin050.importscript.ui.ImportClientProgram;
import com.constellio.plugin050.networkShareConversion.ui.NetworkShareExportProgram;
import com.constellio.plugin050.util.ImportConfigurationsManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Scanner;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportClientMain {
    private static final Logger log = LoggerFactory.getLogger(ImportClientMain.class);
    private static String username;
    private static ImportConfigurationsManager configManager;
    private static ImportClientLegacyAuthentificationManager authentificationManager;
    private static HttpConfigurations authConfig;

    public static void main(String[] args) {
        try {
            System.setErr(new PrintStream(new FileOutputStream("log.txt", true), true));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        String version = System.getProperty("java.version");
        System.out.println(version);
        System.out.println("Utilitaire d'importation/exportation");
        System.out.println("-----------------------------------------");
        authConfig = ImportClientMain.setupAuthConfig();
        ImportClientMain.login(authConfig.getServerUrl());
    }

    private static void appSelectionMenu() {
        try {
            while (true) {
                ImportClientMain.printAsciiLogo();
                System.out.println("\nMenu principal");
                System.out.println("---------------");
                System.out.println("1. \u001b[34mImporter un gabarit d'importation\u001b[0m");
                System.out.println("2. \u001b[34mG\u00e9n\u00e9rer un gabarit d'importation\u001b[0m");
                System.out.println("3. \u001b[0mQuitter");
                Scanner input = new Scanner(System.in);
                String userChoice = input.nextLine();
                if (userChoice.equals("1")) {
                    ImportClientProgram importClient = new ImportClientProgram(authConfig);
                    ImportClientProgram.main(null);
                    continue;
                }
                if (userChoice.equals("2")) {
                    NetworkShareExportProgram exportProgram = new NetworkShareExportProgram(authConfig);
                    NetworkShareExportProgram.main(null);
                    continue;
                }
                if (userChoice.equals("3")) {
                    System.exit(0);
                    continue;
                }
                System.out.println("\u001b[31mCommande invalide.\u001b[0m");
            }
        }
        catch (Exception unhandledError) {
            System.out.println("\u001b[31mUne erreur est survenue durant l'op\u00e9ration. Retour au menu principal.\u001b[0m");
            ClientLogWriter logWriter = new ClientLogWriter("log.txt");
            logWriter.writeMessageToLogFile("\u001b[31mUne erreur est survenue durant l'op\u00e9ration. Retour au menu principal.\u001b[0m");
            logWriter.writeMessageToLogFile(unhandledError.getMessage());
            ImportClientMain.appSelectionMenu();
            return;
        }
    }

    private static void printAsciiLogo() {
        int red = 25;
        int green = 125;
        int blue = 225;
        String constellioBlue = String.format("\u001b[38;2;%d;%d;%dm", red, green, blue);
        System.out.println(constellioBlue);
        System.out.println("   ######    ######     #     ###   ######  ########  #######  ###     ###      ##      ######   # ");
        System.out.println(" ###       ###    ###   ###   ###  ###  #      ##     ##       ###     ###         ## ###    ###   ");
        System.out.println("###       ###      ###  ##### ###   ####       ##     #####    ###     ###      ##   ##       ##   ");
        System.out.println("###       ###      ###  ##  #####      ###     ##     ##       ###     ###      ##   ##       ##   ");
        System.out.println(" ###       ###    ###   ##    ###  ##   ##     ##     ##       ###     ###      ##    ###   ####   ");
        System.out.println("  #######    ######     ##     ##   #####      ##     #######  ####### #######  ##      ######     ");
        System.out.println("\u001b[0m");
    }

    private static HttpConfigurations setupAuthConfig() {
        System.out.println("Configurations du serveur");
        System.out.println("------------------------------");
        configManager = new ImportConfigurationsManager();
        System.out.println(String.format("Lecture du fichier de configurations...", new Object[0]));
        authConfig = configManager.loadConfigFile("configurations/system.properties");
        if (authConfig == null) {
            System.out.println("Le fichier de configuration est introuvable. Veuillez saisir les informations n\u00e9c\u00e9ssaires.");
            authConfig = ImportClientMain.addConfigurationsManually();
        }
        System.out.println(String.format("Adresse du serveur: %s", authConfig.getServerUrl()));
        return authConfig;
    }

    public static void login(URL constellioURL) {
        System.out.println("\u001b[33mVeuillez vous authentifier dans le navigateur.\u001b[0m");
        Consumer<WebSignInResponse> signInResponseConsumer = webSignInResponse -> {
            authConfig.setUsername(webSignInResponse.getUsername());
            authConfig.setRefreshableTokenValue(webSignInResponse.getAccessToken());
            authConfig.setRefreshToken(webSignInResponse.getRefreshToken());
            authConfig.setExpirationDate(webSignInResponse.getExpirationDate());
            authConfig.setServiceKey(webSignInResponse.getServiceKey());
            authConfig.setOauth2ClientSecret(webSignInResponse.getClientSecret());
            ImportClientMain.appSelectionMenu();
        };
        DuplexAuthenticationServices authServices = authConfig.isAuthenticateWithOauth2() ? new DuplexAuthenticationServices(AuthenticationType.OAUTH2, authConfig.getOauth2ClientId(), authConfig.getOauth2State()) : new DuplexAuthenticationServices();
        authServices.openLoginToConstellioInBrowser(constellioURL, signInResponseConsumer);
    }

    private static HttpConfigurations addConfigurationsManually() {
        Scanner input = new Scanner(System.in);
        boolean urlIsValid = false;
        HttpConfigurations config = null;
        while (!urlIsValid) {
            System.out.println("URL de Constellio:");
            String urlString = input.nextLine();
            URL url = null;
            try {
                url = new URL(urlString);
                config = new HttpConfigurations(url);
                configManager.createNewConfigFile(config, "configurations/system.properties");
                urlIsValid = true;
            }
            catch (MalformedURLException e) {
                System.out.println("L'URL saisie est invalide.");
                System.out.println("Format attendu:\t \u001b[33mhttp://[domain]/constellio\u001b[0m");
            }
        }
        return config;
    }

    public static void buildAppStructure(String rootpath) {
        File root = new File(rootpath);
        File binDir = new File(root, "bin/");
        File configDir = new File(root, "configurations/");
        File dataDir = new File(root, "data/");
        File configFile = new File(configDir, "system.properties");
        try {
            binDir.mkdir();
            configDir.mkdir();
            dataDir.mkdir();
            configFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

