/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.importscript;

import com.constellio.plugin050.importscript.data.batchImport.BatchImportConnection;
import com.constellio.plugin050.importscript.data.batchImport.NoSuchRecordException;
import com.constellio.plugin050.importscript.exceptions.BatchImportSocketConstellioServicesRuntimeException;
import com.constellio.plugin050.importscript.exceptions.ServerUnavailableException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ContextedRuntimeException;

public class FileContentConverter {
    private String filePath;
    private String username;
    private String collection;
    private BatchImportConnection connection;
    public static final String COLLECTION = "collection";
    public static final String USERNAME = "username";
    public static final String TOKEN_OR_PASSWORD = "token";

    public FileContentConverter(BatchImportConnection connection) {
        this.connection = connection;
    }

    public String uploadContentInVault(String fileAbsolutePath, String fileName) {
        HashMap<String, Object> inParams = new HashMap<String, Object>();
        inParams.put("fileAbsolutePath", fileAbsolutePath);
        inParams.put("fileName", fileName);
        Map hashResponse = (Map)this.callService("/uploadContentInVault", inParams, true);
        return (String)hashResponse.get("hash");
    }

    public <T> T callService(String servletPath, Map<String, Object> inParams, boolean timeout) {
        String throwableStackTrace;
        String throwableMessage;
        String throwableClassName;
        InputStream input;
        OutputStream output;
        HttpURLConnection outConnection;
        block16: {
            String baseURL = this.connection.getUrl();
            if (this.connection.getUrl() == null) {
                throw new ServerUnavailableException();
            }
            outConnection = null;
            output = null;
            input = null;
            if (!baseURL.endsWith("/")) {
                baseURL = baseURL + "/";
            }
            baseURL = baseURL + "batchImport";
            URL serviceURL = new URL(baseURL + servletPath);
            try {
                outConnection = (HttpURLConnection)serviceURL.openConnection();
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new ServerUnavailableException(t);
            }
            if (timeout) {
                outConnection.setConnectTimeout(2000);
            }
            if ("/uploadContentInVault".equals(servletPath)) {
                outConnection.setRequestMethod("POST");
                outConnection.setDoInput(true);
                outConnection.setDoOutput(true);
                outConnection.setUseCaches(false);
                outConnection.setDefaultUseCaches(false);
                outConnection.addRequestProperty("fileName", (String)inParams.get("fileName"));
                outConnection.addRequestProperty(this.username, this.connection.getUsername());
                outConnection.addRequestProperty(TOKEN_OR_PASSWORD, this.connection.getToken());
                int bufferSize = 0x100000;
                outConnection.setChunkedStreamingMode(0x100000);
                outConnection.connect();
                File fileToSend = new File((String)inParams.get("fileAbsolutePath"));
                output = outConnection.getOutputStream();
                FileInputStream fileInputStream = new FileInputStream(fileToSend);
                IOUtils.copy((InputStream)fileInputStream, output);
            } else {
                inParams.put(this.username, this.connection.getUsername());
                inParams.put(COLLECTION, this.connection.getCollection());
                inParams.put(TOKEN_OR_PASSWORD, this.connection.getToken().getBytes(Charset.forName("UTF-8")));
                outConnection.setDoOutput(true);
                output = outConnection.getOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(output);
                oos.writeObject(inParams);
            }
            input = outConnection.getInputStream();
            ObjectInputStream ois = new ObjectInputStream(input);
            Map deserialized = (Map)ois.readObject();
            Object result = deserialized.get("result");
            throwableClassName = (String)deserialized.get("throwableClassName");
            throwableMessage = (String)deserialized.get("throwableMessage");
            throwableStackTrace = (String)deserialized.get("throwableStackTrace");
            if (throwableClassName != null) break block16;
            Object v = result;
            IOUtils.closeQuietly(input);
            IOUtils.closeQuietly(output);
            IOUtils.close(outConnection);
            return (T)v;
        }
        try {
            try {
                ContextedRuntimeException contextedRuntimeException = new ContextedRuntimeException(throwableMessage);
                contextedRuntimeException.addContextValue("className", throwableClassName);
                contextedRuntimeException.addContextValue("stackTrace", throwableStackTrace);
                throw contextedRuntimeException;
            }
            catch (Throwable t) {
                t.printStackTrace();
                if (t.getMessage() != null && t.getMessage().contains("401")) {
                    throw new BatchImportSocketConstellioServicesRuntimeException.BatchImportSocketConstellioServicesRuntimeException_UnauthorizedAccess();
                }
                if (t instanceof ContextedRuntimeException) {
                    ContextedRuntimeException contextedRuntimeException = (ContextedRuntimeException)t;
                    String message = contextedRuntimeException.getRawMessage();
                    String className = (String)contextedRuntimeException.getFirstContextValue("className");
                    if (className.startsWith("com.constellio.model.services.records.RecordServicesRuntimeException")) {
                        throw new NoSuchRecordException(message);
                    }
                    throw contextedRuntimeException;
                }
                if (t instanceof ConnectException) {
                    throw new ServerUnavailableException(t);
                }
                throw new RuntimeException(t);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            IOUtils.closeQuietly(output);
            IOUtils.close(outConnection);
            throw throwable;
        }
    }
}

