/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.auth.webSignIn.duplex.signin.result;

import com.constellio.plugin050.auth.webSignIn.duplex.events.EventArgs;
import com.constellio.plugin050.auth.webSignIn.duplex.events.EventListener;
import com.constellio.plugin050.auth.webSignIn.duplex.events.EventObservable;
import com.constellio.plugin050.auth.webSignIn.duplex.signin.DuplexSignInContext;
import com.constellio.plugin050.auth.webSignIn.duplex.signin.DuplexSignInResult;
import com.constellio.plugin050.auth.webSignIn.duplex.signin.result.WaitingForDuplexSignInResultHTTPServer;
import java.net.URI;

public class WaitingForDuplexSignInResultContext {
    private DuplexSignInResult duplexSignInResult;
    private AuthenticationState authenticationState;
    private final DuplexSignInContext duplexSignInContext;
    private final WaitingForDuplexSignInResultHTTPServer server;
    private final AuthenticationStateChangedObservable authenticationStateChangedObservable;
    private String error;

    public WaitingForDuplexSignInResultContext(DuplexSignInContext duplexSignInContext, WaitingForDuplexSignInResultHTTPServer server, AuthenticationState authenticationState) {
        this.duplexSignInContext = duplexSignInContext;
        this.server = server;
        this.authenticationState = authenticationState;
        this.authenticationStateChangedObservable = new AuthenticationStateChangedObservable();
    }

    public DuplexSignInContext getDuplexSignInContext() {
        return this.duplexSignInContext;
    }

    public void stop() {
        this.server.stop();
    }

    public boolean isRunning() {
        return this.server.isRunning();
    }

    public URI getUri() {
        return this.server.getUri();
    }

    public void cancel() {
        this.stop();
        this.setAuthenticationState(AuthenticationState.CANCELLED);
    }

    public void completeAuthentication(DuplexSignInResult duplexSignInResult) {
        this.duplexSignInResult = duplexSignInResult;
        this.setAuthenticationState(AuthenticationState.AUTHENTICATED);
    }

    public void failAuthentication(String error) {
        this.error = error;
        this.setAuthenticationState(AuthenticationState.ERROR);
    }

    public AuthenticationState getAuthenticationState() {
        return this.authenticationState;
    }

    private void setAuthenticationState(AuthenticationState authenticationState) {
        if (authenticationState != this.authenticationState) {
            this.authenticationState = authenticationState;
            this.authenticationStateChangedObservable.fire(new AuthenticationStateChangedArgs(this, authenticationState));
        }
    }

    public void addAuthenticationStateChangedListener(AuthenticationStateChangedListener listener) {
        this.authenticationStateChangedObservable.addListener(listener);
    }

    public void removeAuthenticationStateChangedListener(AuthenticationStateChangedListener listener) {
        this.authenticationStateChangedObservable.addListener(listener);
    }

    public WaitingForDuplexSignInResultHTTPServer getServer() {
        return this.server;
    }

    public String getError() {
        return this.error;
    }

    public DuplexSignInResult getAuthenticationResult() {
        return this.duplexSignInResult;
    }

    public String getAuthenticationId() {
        return this.duplexSignInContext.getAuthenticationId();
    }

    private class AuthenticationStateChangedObservable
    extends EventObservable<AuthenticationStateChangedArgs> {
        private AuthenticationStateChangedObservable() {
        }
    }

    public static interface AuthenticationStateChangedListener
    extends EventListener<AuthenticationStateChangedArgs> {
    }

    public static class AuthenticationStateChangedArgs
    extends EventArgs<WaitingForDuplexSignInResultContext> {
        private final AuthenticationState authenticationState;

        public AuthenticationStateChangedArgs(WaitingForDuplexSignInResultContext sender, AuthenticationState authenticationState) {
            super(sender);
            this.authenticationState = authenticationState;
        }

        public AuthenticationState getAuthenticationState() {
            return this.authenticationState;
        }
    }

    public static enum AuthenticationState {
        AUTHENTICATING,
        AUTHENTICATED,
        CANCELLED,
        ERROR;

    }
}

