/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.auth.webSignIn;

import com.constellio.plugin050.auth.webSignIn.OSServicesImpl;
import com.constellio.plugin050.auth.webSignIn.WebSignInResponse;
import com.constellio.plugin050.auth.webSignIn.duplex.AuthenticationType;
import com.constellio.plugin050.auth.webSignIn.duplex.CancellationToken;
import com.constellio.plugin050.auth.webSignIn.duplex.DuplexAuthenticationConnection;
import com.constellio.plugin050.auth.webSignIn.duplex.signin.DuplexSignInServices;
import com.constellio.plugin050.auth.webSignIn.duplex.signin.result.WaitingForDuplexSignInResultContext;
import com.constellio.plugin050.importscript.data.util.TimeProvider;
import java.net.URI;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.apache.kerby.util.Base64;
import org.json.JSONObject;

public class DuplexAuthenticationServices {
    private String oauth2ClientId;
    private String oauth2State;
    private String codeVerifier;
    private AuthenticationType authenticationType;
    private static final String AUTHORIZE_ENDPOINT = "/oauth/v2/authorize";

    public DuplexAuthenticationServices(AuthenticationType authenticationType, String oauth2ClientId, String oauth2State) {
        this.oauth2ClientId = oauth2ClientId;
        this.oauth2State = oauth2State;
        this.authenticationType = authenticationType;
    }

    public DuplexAuthenticationServices() {
        this.authenticationType = AuthenticationType.STANDARD;
    }

    public void openLoginToConstellioInBrowser(String constellioURL, final Consumer<WebSignInResponse> responseConsumer) {
        final CancellationToken cancellationToken = new CancellationToken();
        final boolean loginWithOauth2 = AuthenticationType.OAUTH2 == this.authenticationType;
        final DuplexAuthenticationConnection connection = new DuplexAuthenticationConnection();
        connection.setUrl(constellioURL);
        final Consumer<WaitingForDuplexSignInResultContext> openAuthenticationPage = waitingForDuplexSignInResultContext -> {
            OSServicesImpl osServices = new OSServicesImpl();
            try {
                URI loginUri;
                if (loginWithOauth2) {
                    this.codeVerifier = this.generateOauth2CodeVerifier();
                    loginUri = this.getOauth2SignInUrl(connection.getUrl(), waitingForDuplexSignInResultContext.getAuthenticationId(), waitingForDuplexSignInResultContext.getUri().getPort());
                } else {
                    loginUri = this.buildStandardLoginURI(connection.getUrl(), waitingForDuplexSignInResultContext.getAuthenticationId(), waitingForDuplexSignInResultContext.getUri().getPort());
                }
                System.out.println(loginUri.toString());
                String openCommand = osServices.getOpenCommand("http", loginUri.toString());
                osServices.runCommand(openCommand);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        new Thread("DuplexAuthenticationServices.WaitingForAuthentication"){

            @Override
            public void run() {
                try {
                    DuplexSignInServices duplexSignInServices = new DuplexSignInServices();
                    duplexSignInServices.authenticate(connection, cancellationToken, openAuthenticationPage);
                    if (connection.getToken() != null) {
                        WebSignInResponse response = new WebSignInResponse();
                        response.setUsername(connection.getUsername());
                        if (loginWithOauth2) {
                            String authorizationCode = connection.getAuthCode();
                            String tokenJson = DuplexAuthenticationServices.this.obtainOauth2Token(connection.getUrl(), authorizationCode);
                            JSONObject jsonObject = new JSONObject(tokenJson);
                            response.setAccessToken(jsonObject.getString("access_token"));
                            int expiresInSeconds = jsonObject.getInt("expires_in");
                            response.setExpirationDate(new Date(TimeProvider.getLocalDateTime().toDate().getTime() + (long)(expiresInSeconds * 1000)));
                            response.setRefreshToken(jsonObject.getString("refresh_token"));
                        } else {
                            response.setAccessToken(connection.getToken());
                        }
                        response.setServiceKey(connection.getServiceKey());
                        responseConsumer.accept(response);
                    }
                }
                catch (Exception e) {
                    System.out.println("A problem occured, please restart the application");
                    System.err.println("Error while authenticating the user. Application should be restarted");
                    e.printStackTrace();
                }
            }
        }.start();
    }

    private URI buildStandardLoginURI(String baseUrl, String authID, int callBackPort) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("isClientWebSignIn", String.valueOf(true));
        params.put("authId", authID);
        params.put("callbackPort", String.valueOf(callBackPort));
        return new URI(this.buildRequestUrlWithParams(baseUrl, params));
    }

    private URI getOauth2SignInUrl(String baseUrl, String authId, int callBackPort) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", this.oauth2ClientId);
        params.put("authId", authId);
        params.put("redirect_uri", "localhost");
        params.put("redirect_port", String.valueOf(callBackPort));
        params.put("state", this.oauth2State);
        params.put("code_challenge", this.generateOauth2CodeChallenge(this.codeVerifier));
        params.put("response_type", "code");
        params.put("code_challenge_method", "S256");
        return new URI(this.buildRequestUrlWithParams(baseUrl + AUTHORIZE_ENDPOINT, params));
    }

    private String buildRequestUrlWithParams(String baseUrl, Map<String, String> params) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(baseUrl);
        if (!params.isEmpty()) {
            stringBuilder.append("/?");
        }
        stringBuilder.append(this.buildRequestParamString(params));
        return stringBuilder.toString();
    }

    private String buildRequestParamString(Map<String, String> params) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Map.Entry<String, String>> paramsIterator = params.entrySet().iterator();
        while (paramsIterator.hasNext()) {
            Map.Entry<String, String> currentParam = paramsIterator.next();
            stringBuilder.append(currentParam.getKey());
            stringBuilder.append("=");
            stringBuilder.append(currentParam.getValue());
            if (!paramsIterator.hasNext()) continue;
            stringBuilder.append("&");
        }
        return stringBuilder.toString();
    }

    private String obtainOauth2Token(String baseUrl, String authCode) {
        Form form = new Form().param("grant_type", "authorization_code").param("client_id", this.oauth2ClientId).param("code", authCode).param("redirect_uri", "localhost").param("code_verifier", this.codeVerifier);
        Client client = ClientBuilder.newClient();
        WebTarget webTarget = client.target(baseUrl + "/oauth/v2/token");
        Response response = webTarget.request().post(Entity.form(form));
        if (response.getStatus() == 200) {
            return response.readEntity(String.class);
        }
        String errorResponse = response.readEntity(String.class);
        throw new RuntimeException("Received unexpected status when trying to exchange the authorization code for the access token: " + response.getStatus() + ", with body: " + errorResponse);
    }

    private String generateOauth2CodeChallenge(String verifier) throws Exception {
        byte[] bytes = verifier.getBytes();
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(bytes, 0, bytes.length);
        byte[] digest = md.digest();
        return Base64.encodeBase64URLSafeString(digest);
    }

    protected String generateOauth2CodeVerifier() {
        SecureRandom sr = new SecureRandom();
        byte[] code = new byte[32];
        sr.nextBytes(code);
        return Base64.encodeBase64URLSafeString(code);
    }
}

