/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.pool;

import com.sun.jndi.ldap.pool.Pool;
import com.sun.jndi.ldap.pool.PooledConnection;

final class ConnectionDesc {
    private static final boolean debug = Pool.debug;
    static final byte BUSY = 0;
    static final byte IDLE = 1;
    static final byte EXPIRED = 2;
    private final PooledConnection conn;
    private byte state = 1;
    private long idleSince;
    private long useCount = 0L;

    ConnectionDesc(PooledConnection pooledConnection) {
        this.conn = pooledConnection;
    }

    ConnectionDesc(PooledConnection pooledConnection, boolean bl) {
        this.conn = pooledConnection;
        if (bl) {
            this.state = 0;
            ++this.useCount;
        }
    }

    public boolean equals(Object object) {
        return object != null && object instanceof ConnectionDesc && ((ConnectionDesc)object).conn == this.conn;
    }

    public int hashCode() {
        return this.conn.hashCode();
    }

    synchronized boolean release() {
        this.d("release()");
        if (this.state == 0) {
            this.state = 1;
            this.idleSince = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    synchronized PooledConnection tryUse() {
        this.d("tryUse()");
        if (this.state == 1) {
            this.state = 0;
            ++this.useCount;
            return this.conn;
        }
        return null;
    }

    synchronized boolean expire(long l) {
        if (this.state == 1 && this.idleSince < l) {
            this.d("expire(): expired");
            this.state = (byte)2;
            this.conn.closeConnection();
            return true;
        }
        this.d("expire(): not expired");
        return false;
    }

    public String toString() {
        return this.conn.toString() + " " + (this.state == 0 ? "busy" : (this.state == 1 ? "idle" : "expired"));
    }

    int getState() {
        return this.state;
    }

    long getUseCount() {
        return this.useCount;
    }

    private void d(String string) {
        if (debug) {
            System.err.println("ConnectionDesc." + string + " " + this.toString());
        }
    }
}

