/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.importscript.ui;

import com.constellio.plugin050.ImportClientLabels;
import com.constellio.plugin050.importscript.CellContent;
import com.constellio.plugin050.importscript.ExcelFileImporter;
import com.constellio.plugin050.importscript.HttpConfigurations;
import com.constellio.plugin050.util.ImportConfigurationsManager;
import com.constellio.plugin050.util.ImportScriptConstants;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;

public class ImportClientProgram {
    private static String INPUT_FOLDER_PROPERTY = ImportScriptConstants.CONFIG_IMPORT_INPUT_FILE;
    private static String OUTPUT_FOLDER_PROPERTY = ImportScriptConstants.CONFIG_IMPORT_OUTPUT_PATH;
    private static HttpConfigurations config;
    private static ImportConfigurationsManager configManager;
    private static boolean applicationRunning;
    private static HashMap<String, String> skippedContents;

    public ImportClientProgram(HttpConfigurations config) {
        ImportClientProgram.config = config;
        configManager = new ImportConfigurationsManager(config.getConfigFile());
    }

    public static void main(String[] args) throws Exception {
        while (applicationRunning) {
            ImportClientProgram.importMenu();
        }
    }

    private static void importMenu() throws Exception {
        Scanner input = new Scanner(System.in);
        block10: while (applicationRunning) {
            String userChoice;
            System.out.println("\nMenu - Importation dans Constellio");
            System.out.println("-----------------------------------");
            System.out.println("1. Lancer l'importation des contenus");
            System.out.println("2. Configurations de l'importation");
            System.out.println("3. Retour au menu principal");
            switch (userChoice = input.nextLine()) {
                case "1": {
                    String tempFile = ImportClientProgram.convertFile();
                    if (tempFile == null) continue block10;
                    ImportClientProgram.uploadRecords(tempFile);
                    continue block10;
                }
                case "2": {
                    ImportClientProgram.setFileToImport();
                    continue block10;
                }
                case "3": {
                    applicationRunning = false;
                    continue block10;
                }
            }
            System.out.println("Commande invalide.");
        }
    }

    private static void setFileToImport() {
        Scanner input = new Scanner(System.in);
        boolean userCmd = false;
        block10: while (!userCmd) {
            String userChoice;
            System.out.println("Configurations d'importation");
            System.out.println("------------------------------");
            System.out.println("1. D\u00e9finir le fichier source");
            System.out.println("2. D\u00e9finir le dossier temporaire pour la copie");
            System.out.println("3. Retour");
            switch (userChoice = input.nextLine()) {
                case "1": {
                    ImportClientProgram.setSourceFile();
                    continue block10;
                }
                case "2": {
                    ImportClientProgram.setDestFile();
                    continue block10;
                }
                case "3": {
                    userCmd = true;
                    continue block10;
                }
            }
            System.out.println("Commande invalide.");
        }
    }

    private static void setSourceFile() {
        String userChoice;
        String inputFolder = configManager.readProperty(INPUT_FOLDER_PROPERTY);
        if (inputFolder == null) {
            System.out.println(String.format("Fichier source actuel (par d\u00e9faut): %s", ImportScriptConstants.DATA_FOLDER + ExcelFileImporter.DEFAULT_FILE));
        } else {
            System.out.println(String.format("Fichier source actuel: %s", inputFolder));
        }
        Scanner input = new Scanner(System.in);
        System.out.println("1. Utiliser un autre fichier");
        System.out.println("2. Retour");
        switch (userChoice = input.nextLine()) {
            case "1": {
                System.out.println("Saisir le chemin complet vers fichier \u00e0 importer:");
                String path = input.nextLine();
                configManager.writeProperty(INPUT_FOLDER_PROPERTY, path);
                System.out.println(String.format("Le fichier source est d\u00e9sormais %s", configManager.readProperty(INPUT_FOLDER_PROPERTY)));
                return;
            }
            case "2": {
                return;
            }
        }
        System.out.println("Commande invalide.");
    }

    private static void setDestFile() {
        String userChoice;
        String inputFolder = configManager.readProperty(OUTPUT_FOLDER_PROPERTY);
        if (inputFolder == null) {
            System.out.println(String.format("Dossier de destination actuel (par d\u00e9faut): %s", ExcelFileImporter.DEFAULT_PATH));
        } else {
            System.out.println(String.format("Dossier de destination actuel: %s", inputFolder));
        }
        Scanner input = new Scanner(System.in);
        System.out.println("1. Utiliser un autre dossier");
        System.out.println("2. Retour");
        switch (userChoice = input.nextLine()) {
            case "1": {
                System.out.println("Saisir le chemin complet vers dossier:");
                String path = input.nextLine();
                configManager.writeProperty(OUTPUT_FOLDER_PROPERTY, path);
                System.out.println(String.format("Le dossier de destination est d\u00e9sormais %s", configManager.readProperty(OUTPUT_FOLDER_PROPERTY)));
                return;
            }
            case "2": {
                return;
            }
        }
        System.out.println("Commande invalide.");
    }

    private static String convertFile() throws FileNotFoundException {
        String collection = config.getCollection();
        if (collection == null) {
            Scanner input = new Scanner(System.in);
            System.out.println(ImportClientLabels.IMPORTCLIENT_COLLECTION_PROMPT);
            collection = input.nextLine();
        }
        config.setCollection(collection);
        ExcelFileImporter importer = new ExcelFileImporter(config);
        System.out.println("Validation des m\u00e9tadonn\u00e9es...");
        File validationFile = importer.createValidationFile();
        if (importer.validateExcelFile(validationFile.getAbsolutePath())) {
            String importableFile;
            importer.readAlreadyUploadedFile();
            List<CellContent> imported = importer.uploadContent();
            skippedContents = importer.getSkippedContents();
            String string = importableFile = imported == null ? null : importer.writeImportableFile(imported);
            if (importableFile == null) {
                System.out.println("Une erreur est survenue lors de  la conversion des documents.");
                System.out.println("Veuillez v\u00e9rifier le fichier d'importation.");
            }
            return importableFile;
        }
        return null;
    }

    private static void uploadRecords(String tempFilePath) {
        System.out.println("Importation des m\u00e9tadonn\u00e9es...");
        ExcelFileImporter importer = new ExcelFileImporter(config, skippedContents);
        importer.uploadExcelFile(tempFilePath);
    }

    static {
        applicationRunning = true;
    }
}

