/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.auth.webSignIn.duplex.signin;

import com.constellio.plugin050.auth.webSignIn.duplex.CancellationToken;
import com.constellio.plugin050.auth.webSignIn.duplex.DuplexAuthenticationConnection;
import com.constellio.plugin050.auth.webSignIn.duplex.signin.DuplexSignInContext;
import com.constellio.plugin050.auth.webSignIn.duplex.signin.DuplexSignInResult;
import com.constellio.plugin050.auth.webSignIn.duplex.signin.result.WaitingForDuplexSignInResultContext;
import com.constellio.plugin050.auth.webSignIn.duplex.signin.result.WaitingForDuplexSignInResultHTTPServer;
import com.constellio.plugin050.auth.webSignIn.exceptions.DuplexSignInException;
import com.constellio.plugin050.auth.webSignIn.exceptions.DuplexSignInRuntimeException;
import java.util.function.Consumer;

public class DuplexSignInServices {
    public void authenticate(DuplexAuthenticationConnection connection, CancellationToken cancellationToken, Consumer<WaitingForDuplexSignInResultContext> runBeforeWaitingForResponse) {
        WaitingForDuplexSignInResultHTTPServer authServer = new WaitingForDuplexSignInResultHTTPServer();
        try {
            DuplexSignInContext duplexSignInContext = new DuplexSignInContext(connection);
            WaitingForDuplexSignInResultContext waitingForDuplexSignInResultContext = authServer.start(duplexSignInContext);
            if (!cancellationToken.isCancelled()) {
                cancellationToken.addCancellationRequestedListener(args -> {
                    if (waitingForDuplexSignInResultContext.isRunning()) {
                        waitingForDuplexSignInResultContext.cancel();
                    }
                });
            }
            waitingForDuplexSignInResultContext.addAuthenticationStateChangedListener(args -> {
                WaitingForDuplexSignInResultContext.AuthenticationState authenticationState = args.getAuthenticationState();
                if (authenticationState == WaitingForDuplexSignInResultContext.AuthenticationState.AUTHENTICATED || authenticationState == WaitingForDuplexSignInResultContext.AuthenticationState.ERROR) {
                    waitingForDuplexSignInResultContext.stop();
                }
            });
            runBeforeWaitingForResponse.accept(waitingForDuplexSignInResultContext);
            authServer.join();
            WaitingForDuplexSignInResultContext.AuthenticationState authenticationState = waitingForDuplexSignInResultContext.getAuthenticationState();
            if (authenticationState == WaitingForDuplexSignInResultContext.AuthenticationState.AUTHENTICATED) {
                DuplexSignInResult duplexSignInResult = waitingForDuplexSignInResultContext.getAuthenticationResult();
                connection.setCollection(duplexSignInResult.getCollection());
                connection.setUsername(duplexSignInResult.getUsername());
                connection.setToken(duplexSignInResult.getAccessToken());
                connection.setAuthCode(duplexSignInResult.getAuthCode());
                connection.setRefreshToken(duplexSignInResult.getRefreshToken());
                connection.setServiceKey(duplexSignInResult.getServiceKey());
            } else if (authenticationState == WaitingForDuplexSignInResultContext.AuthenticationState.ERROR) {
                throw new DuplexSignInRuntimeException.FailedAuthentication_DuplexSignInRuntimeException(waitingForDuplexSignInResultContext.getError());
            }
        }
        catch (DuplexSignInException.ServerIsAlreadyRunning_DuplexSignInException serverIsAlreadyRunning_DuplexSignInException) {
            // empty catch block
        }
    }
}

