/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050;

import com.constellio.plugin050.auth.ImportClientLegacyAuthentificationManager;
import com.constellio.plugin050.auth.webSignIn.DuplexAuthenticationServices;
import com.constellio.plugin050.auth.webSignIn.WebSignInResponse;
import com.constellio.plugin050.auth.webSignIn.duplex.AuthenticationType;
import com.constellio.plugin050.importscript.HttpConfigurations;
import com.constellio.plugin050.importscript.ui.ImportClientProgram;
import com.constellio.plugin050.networkShareConversion.ui.NetworkShareExportProgram;
import com.constellio.plugin050.util.ImportConfigurationsManager;
import com.constellio.plugin050.util.ImportScriptConstants;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Scanner;
import java.util.function.Consumer;

public class ImportClientMain {
    private static String username;
    private static ImportConfigurationsManager configManager;
    private static ImportClientLegacyAuthentificationManager authentificationManager;
    private static HttpConfigurations authConfig;

    public static void main(String[] args) {
        try {
            System.setErr(new PrintStream(new FileOutputStream(ImportScriptConstants.LOG_FILE_NAME, true), true));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        String version = System.getProperty("java.version");
        System.out.println(version);
        System.out.println("Utilitaire d'importation/exportation");
        System.out.println("-----------------------------------------");
        authConfig = ImportClientMain.setupAuthConfig();
        ImportClientMain.login(authConfig.getAdress());
    }

    private static void appSelectionMenu() {
        try {
            while (true) {
                System.out.println("\nMenu principal");
                System.out.println("---------------");
                System.out.println("1. Client d'importation");
                System.out.println("2. Client d'exportation de partage r\u00e9seau");
                System.out.println("3. Informations du serveur");
                System.out.println("4. Quitter");
                Scanner input = new Scanner(System.in);
                String userChoice = input.nextLine();
                if (userChoice.equals("1")) {
                    ImportClientProgram importClient = new ImportClientProgram(authConfig);
                    ImportClientProgram.main(null);
                    continue;
                }
                if (userChoice.equals("2")) {
                    NetworkShareExportProgram exportProgram = new NetworkShareExportProgram(authConfig);
                    NetworkShareExportProgram.main(null);
                    continue;
                }
                if (userChoice.equals("3")) {
                    ImportClientMain.setupAuthConfig();
                    continue;
                }
                if (userChoice.equals("4")) {
                    System.exit(0);
                    continue;
                }
                System.out.println("Commande invalide.");
            }
        }
        catch (Exception unhandledError) {
            System.out.println("Une erreur est survenue durant l'op\u00e9ration. Retour au menu principal.");
            System.out.println(unhandledError.getMessage());
            ImportClientMain.appSelectionMenu();
            return;
        }
    }

    private static HttpConfigurations setupAuthConfig() {
        System.out.println("Configurations du serveur");
        System.out.println("------------------------------");
        configManager = new ImportConfigurationsManager();
        System.out.println(String.format("Lecture du fichier de configurations...", new Object[0]));
        authConfig = configManager.loadConfigFile(ImportScriptConstants.CONFIGURATIONS_FOLDER + ImportScriptConstants.CONFIG_FILE_NAME);
        if (authConfig == null) {
            System.out.println("Le fichier de configuration est introuvable. Veuillez saisir les informations n\u00e9c\u00e9ssaires.");
            authConfig = ImportClientMain.addConfigurationsManually();
        }
        System.out.println(String.format("Adresse du serveur: %s", authConfig.getAdress()));
        return authConfig;
    }

    public static void login(String constellioURL) {
        System.out.println("Le page d'authentification devrait s'ouvrir automatiquement dans le navigateur.");
        Consumer<WebSignInResponse> signInResponseConsumer = webSignInResponse -> {
            authConfig.setUsername(webSignInResponse.getUsername());
            authConfig.setRefreshableTokenValue(webSignInResponse.getAccessToken());
            authConfig.setRefreshToken(webSignInResponse.getRefreshToken());
            authConfig.setExpirationDate(webSignInResponse.getExpirationDate());
            authConfig.setServiceKey(webSignInResponse.getServiceKey());
            authConfig.setOauth2ClientSecret(webSignInResponse.getClientSecret());
            if (ImportClientMain.checkForPreviousUploadAttempt()) {
                System.out.println("Une importation non termin\u00e9e a \u00e9t\u00e9 d\u00e9tect\u00e9e. Vous pourrez la terminer en relancant l'importation.");
            }
            ImportClientMain.appSelectionMenu();
        };
        DuplexAuthenticationServices authServices = authConfig.isAuthenticateWithOauth2() ? new DuplexAuthenticationServices(AuthenticationType.OAUTH2, authConfig.getOauth2ClientId(), authConfig.getOauth2State()) : new DuplexAuthenticationServices();
        System.out.println("\nVous pouvez \u00e9galement y acc\u00e9der directement \u00e0 partir de ce lien:");
        authServices.openLoginToConstellioInBrowser(constellioURL, signInResponseConsumer);
    }

    private static HttpConfigurations addConfigurationsManually() {
        Scanner input = new Scanner(System.in);
        System.out.println("Adresse du serveur:");
        String host = input.nextLine();
        System.out.println("Port:");
        String port = input.nextLine();
        HttpConfigurations config = new HttpConfigurations(host, port);
        configManager.createNewConfigFile(config, ImportScriptConstants.CONFIGURATIONS_FOLDER + ImportScriptConstants.CONFIG_FILE_NAME);
        return config;
    }

    public static void buildAppStructure(String rootpath) {
        File root = new File(rootpath);
        File binDir = new File(root, ImportScriptConstants.BIN_FOLDER);
        File configDir = new File(root, ImportScriptConstants.CONFIGURATIONS_FOLDER);
        File dataDir = new File(root, ImportScriptConstants.DATA_FOLDER);
        File configFile = new File(configDir, ImportScriptConstants.CONFIG_FILE_NAME);
        try {
            binDir.mkdir();
            configDir.mkdir();
            dataDir.mkdir();
            configFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean checkForPreviousUploadAttempt() {
        String alreadyUploadedFilePath = ImportScriptConstants.DATA_FOLDER + "Recuperation" + "." + authConfig.getHost() + "." + authConfig.getPort();
        File alreadyUploadedFile = new File(alreadyUploadedFilePath);
        return alreadyUploadedFile.exists();
    }
}

