/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.networkShareConversion;

import com.constellio.plugin050.importscript.HttpConfigurations;
import com.constellio.plugin050.networkShareConversion.FetchRetentionRulesService;
import com.constellio.plugin050.networkShareConversion.FileSystemExportConfig;
import com.constellio.plugin050.networkShareConversion.FileSystemParser;
import com.constellio.plugin050.networkShareConversion.wrappers.CategoryWrapper;
import com.constellio.plugin050.networkShareConversion.wrappers.DocumentWrapper;
import com.constellio.plugin050.networkShareConversion.wrappers.FolderWrapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;

public class FileSystemConverter {
    private FileSystemParser parser;
    private List<FolderWrapper> foldersToImport;
    private List<DocumentWrapper> documentsToImport;
    private FileSystemExportConfig config;
    private HttpConfigurations httpConfig;
    private Map<String, List<String>> retentionRulesCache;
    private List<CategoryWrapper> categoriesList;
    private static String LIST_SEPARATOR = ";";
    private static String DATA_FOLDER = "/data/";
    private static String DEFAULT_CATEGORY_ENTERED_VALUE = "P";

    public FileSystemConverter(FileSystemExportConfig config, HttpConfigurations httpConfig) {
        this.config = config;
        this.httpConfig = httpConfig;
        this.parser = new FileSystemParser(config.getRootPath());
    }

    public void convert() {
        System.out.println("D\u00e9marrage de l'exportation");
        System.out.println("==========================");
        this.parser.parse();
        if (this.config.isUseCategoryRegex().booleanValue()) {
            this.categoriesList = this.parseCategoriesList(this.parser.getDirectories());
        } else {
            CategoryWrapper defaultCategory = new CategoryWrapper();
            defaultCategory.setCode(this.config.getDefaultCategory());
            this.categoriesList = Arrays.asList(defaultCategory);
        }
        this.retentionRulesCache = new FetchRetentionRulesService(this.httpConfig).fetchRetentionRules(this.categoriesList);
        this.foldersToImport = this.collectFolderMetadatas(this.parser.getDirectories());
        this.documentsToImport = this.collectDocumentsMetadatas(this.parser.getFiles());
    }

    private void printExportConfigurations(FileSystemExportConfig config) {
        System.out.println("\nConfigurations:");
        System.out.println("-----------------");
        System.out.println("Chemin: " + config.getRootPath());
        System.out.println("Unit\u00e9 administrative: " + config.getAdministrativeUnit());
        System.out.println("D\u00e9tection automatique des rubriques: " + config.isUseCategoryRegex());
        if (config.isUseCategoryRegex().booleanValue()) {
            System.out.println("Expression r\u00e9guli\u00e8re (rubriques): " + config.getCategoryRegex());
        } else {
            System.out.println("Rubrique par d\u00e9faut: " + config.getDefaultCategory());
        }
        System.out.println("-----------------------------");
    }

    public List<FolderWrapper> getFoldersToImport() {
        return this.foldersToImport;
    }

    public List<DocumentWrapper> getDocumentsToImport() {
        return this.documentsToImport;
    }

    public String getRootFolderName() {
        File rootFile = new File(this.parser.getRootPath());
        return rootFile.getName();
    }

    private List<FolderWrapper> collectFolderMetadatas(Collection<File> dirs) {
        ArrayList<FolderWrapper> foldersList = new ArrayList<FolderWrapper>();
        for (File dir : dirs) {
            FolderWrapper folder = new FolderWrapper();
            folder.setId(dir.getAbsolutePath());
            folder.setParent(this.findParentPath(dir, folder));
            folder.setTitle(dir.getName());
            SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            folder.setModifiedOn(dateTimeFormat.format(dir.lastModified()));
            dateTimeFormat.format(dir.lastModified());
            folder.setSchema("default");
            folder.setAdministrativeUnit(this.config.getAdministrativeUnit());
            folder.setCopyStatus(DEFAULT_CATEGORY_ENTERED_VALUE);
            String categoryCode = this.config.getDefaultCategory();
            if (this.config.isUseCategoryRegex().booleanValue()) {
                if (this.isFolderCategory(folder.getTitle())) {
                    CategoryWrapper category = new CategoryWrapper();
                    category.setCode(this.extractCategoryCodeFromTitle(folder.getTitle()));
                    this.categoriesList.add(category);
                    continue;
                }
                categoryCode = this.parseCategoryCode(dir);
            }
            folder.setCategory(categoryCode);
            folder.setRetentionRule(this.getFirstRetentionRule(categoryCode));
            BasicFileAttributes attributes = this.getFileAttribute(dir);
            if (attributes != null) {
                long creationTime = attributes.creationTime().toMillis();
                folder.setOpeningDate(dateFormat.format(new Date(creationTime)));
                folder.setCreatedOn(dateFormat.format(new Date(creationTime)));
            }
            foldersList.add(folder);
        }
        return foldersList;
    }

    private String extractCategoryCodeFromTitle(String title) {
        Pattern pattern = Pattern.compile(this.config.getCategoryRegex());
        Matcher matcher = pattern.matcher(title);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    private boolean isRootDirectory(String dirPath) {
        return dirPath.equals(this.parser.getRootPath());
    }

    private BasicFileAttributes getFileAttribute(File file) {
        try {
            return Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private List<DocumentWrapper> collectDocumentsMetadatas(Collection<File> files) {
        ArrayList<DocumentWrapper> documentsList = new ArrayList<DocumentWrapper>();
        for (File file : files) {
            DocumentWrapper document = new DocumentWrapper();
            document.setId(file.getAbsolutePath());
            document.setFolder(file.getParent());
            document.setSchema("default");
            document.setTitle(file.getName());
            document.setContent(file.getAbsolutePath());
            try {
                BasicFileAttributes attributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                document.setCreationDate(new DateTime(attributes.creationTime().toMillis()));
                document.setModificationDate(new DateTime(attributes.lastModifiedTime().toMillis()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            documentsList.add(document);
        }
        return documentsList;
    }

    private String buildRetentionRulesString(String categoryCode) {
        List<String> retentionRules = this.retentionRulesCache.get(categoryCode);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < retentionRules.size(); ++i) {
            builder.append(retentionRules.get(i));
            if (i == retentionRules.size() - 1) continue;
            builder.append(LIST_SEPARATOR);
        }
        return builder.toString();
    }

    private String getFirstRetentionRule(String categoryCode) {
        List<String> retentionRules = this.retentionRulesCache.get(categoryCode);
        if (retentionRules != null && retentionRules.size() >= 1) {
            return this.retentionRulesCache.get(categoryCode).get(0);
        }
        System.out.println(String.format("ATTENTION: Il n'y a aucune r\u00e8gle de conservation associ\u00e9e la cat\u00e9gorie %s", categoryCode));
        return null;
    }

    private String parseCategoryCode(File dir) {
        if (this.config.isUseCategoryRegex().booleanValue()) {
            Pattern pattern = Pattern.compile(this.config.getCategoryRegex());
            Matcher matcher = pattern.matcher(dir.getName());
            if (matcher.find()) {
                System.out.println(String.format("error: file '%s' is category", dir.getName()));
                return null;
            }
            return this.findCategoryCode(dir, pattern);
        }
        return this.config.getDefaultCategory();
    }

    private String findCategoryCode(File dir, Pattern pattern) {
        Matcher matcher = pattern.matcher(dir.getName());
        if (matcher.find()) {
            return StringUtils.trim(matcher.group());
        }
        File parent = dir.getParentFile();
        if (parent == null) {
            return null;
        }
        return this.findCategoryCode(parent, pattern);
    }

    private List<CategoryWrapper> parseCategoriesList(Collection<File> directories) {
        ArrayList<CategoryWrapper> categoriesList = new ArrayList<CategoryWrapper>();
        for (File dir : directories) {
            if (!this.isFolderCategory(dir.getName())) continue;
            CategoryWrapper category = new CategoryWrapper();
            category.setTitle(dir.getName());
            category.setCode(this.extractCategoryCodeFromTitle(dir.getName()));
            categoriesList.add(category);
        }
        return categoriesList;
    }

    private String findParentPath(File dir, FolderWrapper folder) {
        if (this.isRootDirectory(dir.getParent())) {
            return null;
        }
        String parentPath = dir.getParent();
        if (!folder.getId().equals(this.parser.getRootPath()) && !this.isFolderCategory(new File(parentPath))) {
            return parentPath;
        }
        return null;
    }

    private boolean isFolderCategory(String folderName) {
        if (this.config.isUseCategoryRegex().booleanValue()) {
            try {
                Pattern pattern = Pattern.compile(this.config.getCategoryRegex());
                Matcher matcher = pattern.matcher(folderName);
                if (matcher.find()) {
                    return true;
                }
            }
            catch (PatternSyntaxException e) {
                System.out.println(String.format("L'expression r\u00e9guli\u00e8re %s est invalide", this.config.getCategoryRegex()));
                System.out.println(e.getDescription());
                e.printStackTrace();
            }
        }
        return false;
    }

    private boolean isFolderCategory(File folder) {
        if (this.config.isUseCategoryRegex().booleanValue()) {
            try {
                Pattern pattern = Pattern.compile(this.config.getCategoryRegex());
                Matcher matcher = pattern.matcher(folder.getName());
                if (matcher.find()) {
                    return true;
                }
            }
            catch (PatternSyntaxException e) {
                System.out.println(String.format("L'expression r\u00e9guli\u00e8re %s est invalide", this.config.getCategoryRegex()));
                System.out.println(e.getDescription());
                e.printStackTrace();
            }
        }
        return false;
    }
}

