/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.networkShareConversion;

import com.constellio.plugin050.importscript.HttpConfigurations;
import com.constellio.plugin050.networkShareConversion.wrappers.CategoryWrapper;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.http.client.utils.URIBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FetchRetentionRulesService {
    private HttpConfigurations httpConfigurations;

    public FetchRetentionRulesService(HttpConfigurations httpConfigurations) {
        this.httpConfigurations = httpConfigurations;
    }

    public Map<String, List<String>> fetchRetentionRules(List<CategoryWrapper> categories) {
        System.out.println("Obtention des r\u00e8gles de conservation");
        HashMap<String, List<String>> retentionRulesMap = new HashMap<String, List<String>>();
        for (CategoryWrapper category : categories) {
            try {
                List<String> retentionRules = this.getRetentionRulesForCategory(category.getCode());
                retentionRulesMap.put(category.getCode(), retentionRules);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return retentionRulesMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getRetentionRulesForCategory(String categoryCode) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setPath(this.httpConfigurations.getAdress() + "/select").addParameter("token", this.httpConfigurations.getRefreshableTokenValue()).addParameter("serviceKey", this.httpConfigurations.getServiceKey()).addParameter("q", "*:*").addParameter("fq", "schema_s:category_*").addParameter("fq", "code_s:" + categoryCode).addParameter("fq", "collection_s:" + this.httpConfigurations.getCollection()).addParameter("rows", "1").addParameter("fl", "retentionRulesId_ss");
        String urlString = uriBuilder.build().toString();
        urlString = urlString.replaceAll("%3A", ":");
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(urlString).openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Content-Type", "application/json; utf-8");
            conn.setRequestProperty("Accept", "application/json");
            try (InputStream is = conn.getInputStream();){
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                dbFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                dbFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                dbFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                dbFactory.setExpandEntityReferences(false);
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(is);
                XPath xPath = XPathFactory.newInstance().newXPath();
                String docExpression = "//doc/arr/str";
                NodeList nodeList = (NodeList)xPath.compile(docExpression).evaluate(doc, XPathConstants.NODESET);
                if (nodeList.getLength() <= 0) return null;
                ArrayList<String> retentionRulesList = new ArrayList<String>();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element docElement = (Element)nodeList.item(i);
                    String retentionRule = docElement.getTextContent();
                    retentionRulesList.add(retentionRule);
                }
                ArrayList<String> arrayList = retentionRulesList;
                return arrayList;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

