/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.networkShareConversion.ui;

import com.constellio.plugin050.importscript.HttpConfigurations;
import com.constellio.plugin050.networkShareConversion.FileSystemConverter;
import com.constellio.plugin050.networkShareConversion.FileSystemExportConfig;
import com.constellio.plugin050.networkShareConversion.FileSystemExportWriter;
import com.constellio.plugin050.util.ImportConfigurationsManager;
import com.constellio.plugin050.util.ImportScriptConstants;
import java.io.File;
import java.util.Scanner;

public class NetworkShareExportProgram {
    private static String TEMPLATE_FILE_NAME = "bin/TEMPLATE";
    private static String OUTPUT_FILE_NAME = "EXPORT.xlsx";
    private static HttpConfigurations httpConfig;
    private static FileSystemExportConfig exportConfig;
    private static ImportConfigurationsManager configManager;

    public NetworkShareExportProgram(HttpConfigurations config) {
        httpConfig = config;
        configManager = new ImportConfigurationsManager(config.getConfigFile());
    }

    public static void main(String[] args) {
        NetworkShareExportProgram.writeHeader();
        boolean applicationRunning = true;
        NetworkShareExportProgram.printExportPath();
        block10: while (applicationRunning) {
            String userChoice;
            Scanner input = new Scanner(System.in);
            System.out.println("Menu - Exportation de partage r\u00e9seau");
            System.out.println("-------------------");
            System.out.println("1. G\u00e9n\u00e9rer le fichier d'importation");
            System.out.println("2. Configurations");
            System.out.println("3. Retour au menu principal");
            switch (userChoice = input.nextLine()) {
                case "1": {
                    NetworkShareExportProgram.loadConfigurations();
                    NetworkShareExportProgram.setMissingConfigurations();
                    FileSystemConverter converter = new FileSystemConverter(exportConfig, httpConfig);
                    File templateFile = NetworkShareExportProgram.setTemplateFile();
                    FileSystemExportWriter writer = new FileSystemExportWriter(converter, templateFile);
                    String exportFileName = converter.getRootFolderName() + "_" + OUTPUT_FILE_NAME;
                    File generatedFile = writer.exportFileSystem(new File(ImportScriptConstants.DATA_FOLDER + exportFileName));
                    System.out.println("\nFichier d'importation g\u00e9n\u00e9r\u00e9:");
                    System.out.println(generatedFile.getAbsolutePath());
                    continue block10;
                }
                case "2": {
                    NetworkShareExportProgram.loadConfigurations();
                    NetworkShareExportProgram.configurationsMenu();
                    continue block10;
                }
                case "3": {
                    applicationRunning = false;
                    continue block10;
                }
            }
            System.out.println("Commande invalide.");
        }
    }

    private static void configurationsMenu() {
        System.out.println("Configurations d'exportation:");
        NetworkShareExportProgram.printExportConfigurations();
        System.out.println("------------------------------");
        Scanner input = new Scanner(System.in);
        boolean choseAnOption = false;
        block8: while (!choseAnOption) {
            String userChoice;
            System.out.println("1. Modifier les configurations");
            System.out.println("2. Retour");
            switch (userChoice = input.nextLine()) {
                case "1": {
                    choseAnOption = true;
                    exportConfig = new FileSystemExportConfig();
                    NetworkShareExportProgram.setMissingConfigurations();
                    continue block8;
                }
                case "2": {
                    choseAnOption = true;
                    continue block8;
                }
            }
            System.out.println("Commande invalide.");
        }
    }

    private static void printExportConfigurations() {
        System.out.println(String.format("\tChemin d'exportation: %s", exportConfig.getRootPath()));
        System.out.println(String.format("\tUnit\u00e9 administrative: %s", exportConfig.getAdministrativeUnit()));
        System.out.println(String.format("\tRubrique par d\u00e9faut: %s", exportConfig.getDefaultCategory()));
        System.out.println(String.format("\tD\u00e9tection automatique des rubriques: %b", exportConfig.isUseCategoryRegex()));
        System.out.println(String.format("\tExpression r\u00e9guli\u00e8re des rubriques: %s", exportConfig.getCategoryRegex()));
    }

    private static File setTemplateFile() {
        File templateFile = new File(TEMPLATE_FILE_NAME);
        while (!templateFile.exists()) {
            System.out.println(String.format("Le fichier '%s' n'a pas \u00e9t\u00e9 trouv\u00e9.", TEMPLATE_FILE_NAME));
            System.out.println("Veuillez indiquer l'emplacement du fichier \u00e0 utiliser:");
            Scanner input = new Scanner(System.in);
            String templatePath = input.nextLine();
            templateFile = new File(templatePath);
        }
        return templateFile;
    }

    private static void setMissingConfigurations() {
        NetworkShareExportProgram.configurePath();
        NetworkShareExportProgram.configureAdministrativeUnits();
        NetworkShareExportProgram.configureCategories();
    }

    private static void configurePath() {
        if (exportConfig.getRootPath() == null) {
            String rootPath = NetworkShareExportProgram.promptRootPath();
            exportConfig.setRootPath(rootPath);
            configManager.writeProperty(ImportScriptConstants.CONFIG_EXPORT_ROOT, rootPath);
        } else {
            System.out.println(String.format("\tChemin d'exportation: %s", exportConfig.getRootPath()));
        }
    }

    private static void configureAdministrativeUnits() {
        if (exportConfig.getAdministrativeUnit() == null) {
            String ua = NetworkShareExportProgram.promptAdministrativeUnit();
            exportConfig.setAdministrativeUnit(ua);
            configManager.writeProperty(ImportScriptConstants.CONFIG_EXPORT_DEFAULT_UA, ua);
        } else {
            System.out.println(String.format("\tUnit\u00e9 administrative: %s", exportConfig.getAdministrativeUnit()));
        }
    }

    private static void printExportPath() {
        String exportPath = configManager.readProperty(ImportScriptConstants.CONFIG_EXPORT_ROOT);
        if (exportPath == null) {
            System.out.println("Aucun chemin d'exportation d\u00e9fini");
        } else {
            System.out.println("Chemin d'exportation:");
            System.out.println(exportPath);
        }
        System.out.println();
    }

    private static void loadConfigurations() {
        System.out.println("Chargement des configurations...");
        if (exportConfig == null) {
            exportConfig = new FileSystemExportConfig();
            exportConfig.setRootPath(configManager.readProperty(ImportScriptConstants.CONFIG_EXPORT_ROOT));
            exportConfig.setAdministrativeUnit(configManager.readProperty(ImportScriptConstants.CONFIG_EXPORT_DEFAULT_UA));
            String useRegexConfig = configManager.readProperty(ImportScriptConstants.CONFIG_EXPORT_USE_CATEGORY_REGEX);
            exportConfig.setDefaultCategory(configManager.readProperty(ImportScriptConstants.CONFIG_EXPORT_DEFAULT_CATEGORY));
            if (useRegexConfig != null) {
                exportConfig.setUseCategoryRegex(Boolean.parseBoolean(useRegexConfig));
            }
            exportConfig.setCategoryRegex(configManager.readProperty(ImportScriptConstants.CONFIG_EXPORT_CATEGORY_REGEX));
        }
    }

    private static String promptRootPath() {
        while (true) {
            Scanner input = new Scanner(System.in);
            System.out.println("Chemin du partage r\u00e9seau \u00e0 exporter:");
            String path = input.nextLine();
            File pathFile = new File(path);
            if (pathFile.exists()) {
                if (pathFile.isDirectory()) {
                    return path;
                }
                System.out.println(String.format("%s n'est pas un dossier.", path));
                continue;
            }
            System.out.println(String.format("%s n'est pas un chemin valide.", path));
        }
    }

    private static String promptAdministrativeUnit() {
        Scanner input = new Scanner(System.in);
        System.out.println("Saisir le code de l'unit\u00e9 administrative \u00e0 utiliser");
        return input.nextLine();
    }

    private static void configureCategories() {
        if (exportConfig.isUseCategoryRegex() == null) {
            NetworkShareExportProgram.setupCategories();
        } else {
            boolean regexDefined;
            System.out.println(String.format("\tD\u00e9tection automatique des rubriques: %b", exportConfig.isUseCategoryRegex()));
            boolean useRegex = exportConfig.isUseCategoryRegex();
            boolean defaultCategoryDefined = exportConfig.getDefaultCategory() != null;
            boolean bl = regexDefined = exportConfig.getCategoryRegex() != null;
            if (useRegex && !regexDefined || !useRegex && !defaultCategoryDefined) {
                NetworkShareExportProgram.setupCategories();
            } else {
                if (defaultCategoryDefined) {
                    System.out.println(String.format("\tRubrique par d\u00e9faut: %s", exportConfig.getDefaultCategory()));
                }
                if (regexDefined) {
                    System.out.println(String.format("\tExpression r\u00e9guli\u00e8re des rubriques: %s", exportConfig.getCategoryRegex()));
                }
            }
        }
    }

    private static void setupCategories() {
        while (true) {
            System.out.println("D\u00e9tection des rubriques");
            System.out.println("1. Utiliser une expression r\u00e9guli\u00e8re");
            System.out.println("2. Utiliser une rubrique par d\u00e9faut");
            Scanner input = new Scanner(System.in);
            String userChoice = input.nextLine();
            if (userChoice.equals("1")) {
                System.out.println("Saisir l'expression r\u00e9guli\u00e8re \u00e0 utiliser");
                exportConfig.setUseCategoryRegex(true);
                String regex = input.nextLine();
                exportConfig.setCategoryRegex(regex);
                configManager.writeProperty(ImportScriptConstants.CONFIG_EXPORT_CATEGORY_REGEX, regex);
                configManager.writeProperty(ImportScriptConstants.CONFIG_EXPORT_USE_CATEGORY_REGEX, Boolean.toString(true));
                return;
            }
            if (userChoice.equals("2")) {
                System.out.println("Saisir la rubrique \u00e0 utiliser");
                exportConfig.setUseCategoryRegex(false);
                String defaultCategory = input.nextLine();
                exportConfig.setDefaultCategory(defaultCategory);
                configManager.writeProperty(ImportScriptConstants.CONFIG_EXPORT_DEFAULT_CATEGORY, defaultCategory);
                configManager.writeProperty(ImportScriptConstants.CONFIG_EXPORT_USE_CATEGORY_REGEX, Boolean.toString(false));
                return;
            }
            System.out.println("Commande invalide.");
        }
    }

    private static String promptRetentionRule() {
        Scanner input = new Scanner(System.in);
        System.out.println("R\u00e8gle de conservation \u00e0 utiliser");
        return input.nextLine();
    }

    private static void writeHeader() {
        String version = System.getProperty("java.version");
        System.out.println(version);
        System.out.println("Utilitaire d'importation de partage r\u00e9seau");
        System.out.println("-----------------------------------------");
    }
}

