/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.importscript;

import com.constellio.plugin050.importscript.CellContent;
import com.constellio.plugin050.importscript.ClientLogWriter;
import com.constellio.plugin050.importscript.HttpConfigurations;
import com.constellio.plugin050.importscript.RecordImportServices;
import com.constellio.plugin050.importscript.data.batchImport.BatchImportConnection;
import com.constellio.plugin050.importscript.data.batchImport.BatchImportSocketConstellioServices;
import com.constellio.plugin050.importscript.data.batchImport.ImportData;
import com.constellio.plugin050.importscript.data.batchImport.ImportDataIterator;
import com.constellio.plugin050.importscript.data.excel.Excel2007ImportDataProvider;
import com.constellio.plugin050.importscript.data.excel.ExcelCell;
import com.constellio.plugin050.importscript.data.excel.ExcelSheet;
import com.constellio.plugin050.util.ImportScriptConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelFileImporter {
    private static String FILE_SUFFIX_IMPORTABLE = "importable";
    private static String FILE_SUFFIX_VALIDATION = "validation";
    private String DOCUMENT_SCHEMA_TYPE = "document";
    private static String INPUT_FOLDER_PROPERTY = ImportScriptConstants.CONFIG_IMPORT_INPUT_FILE;
    private static String OUTPUT_FOLDER_PROPERTY = ImportScriptConstants.CONFIG_IMPORT_OUTPUT_PATH;
    public static String DEFAULT_FILE = "template.xlsx";
    protected static String LOG_FILE_NAME = "log.txt";
    public static String DEFAULT_PATH = "";
    private static String CONTENT_COLUMN_TITLE = "content";
    private HttpConfigurations config;
    private String filePath;
    private String IMPORT_SUCCESS_RESPONSE = "SUCCESS";
    private static long RETRY_FILE_SLEEP_TIME = 500L;
    private static int NB_RETRY_NOT_FOUND_FILES = 3;
    private HashMap<String, String> skippedContents;

    public ExcelFileImporter(HttpConfigurations config) {
        this.config = config;
        String configPath = this.readConfig(INPUT_FOLDER_PROPERTY);
        this.filePath = configPath == null ? ImportScriptConstants.DATA_FOLDER + DEFAULT_FILE : configPath;
        this.skippedContents = new HashMap();
    }

    public ExcelFileImporter(HttpConfigurations config, HashMap<String, String> skippedContents) {
        this.config = config;
        String configPath = this.readConfig(INPUT_FOLDER_PROPERTY);
        this.filePath = configPath == null ? ImportScriptConstants.DATA_FOLDER + DEFAULT_FILE : configPath;
        this.skippedContents = skippedContents == null ? new HashMap() : skippedContents;
    }

    private BatchImportConnection getConnection() {
        BatchImportConnection connection = new BatchImportConnection();
        connection.setToken(this.config.getToken());
        connection.setUrl(this.config.getAdress());
        connection.setUsername(this.config.getUsername());
        connection.setCollection(this.config.getCollection());
        connection.setServiceKey(this.config.getServiceKey());
        return connection;
    }

    public String getImportFilePath() {
        return this.filePath;
    }

    public List<CellContent> uploadContent() {
        List<CellContent> filesToUpload = this.getContentsToUpload(new File(this.filePath));
        if (filesToUpload == null) {
            return null;
        }
        ArrayList<CellContent> uploadedContent = new ArrayList<CellContent>();
        BatchImportSocketConstellioServices importServices = new BatchImportSocketConstellioServices(this.getConnection());
        System.out.println("Importation du contenu des documents...");
        int i = 0;
        for (CellContent cell : filesToUpload) {
            String filePath = cell.getCellValue();
            if (filePath != null) {
                File file = new File(filePath);
                String progressionString = this.generateProgressionString(i, filesToUpload.size());
                boolean uploadInVault = !this.config.isSkipMissingFiles() || file.exists();
                String hash = "";
                if (uploadInVault) {
                    hash = importServices.uploadContentInVault(filePath, file.getName(), progressionString, this.config.isWithConnectionTimeout());
                }
                uploadedContent.add(new CellContent(cell.getX(), cell.getY(), hash));
            }
            ++i;
        }
        return uploadedContent;
    }

    private String generateProgressionString(int index, int size) {
        StringBuilder sb = new StringBuilder().append("[").append(index + 1).append("/").append(size).append("]").append(" \t");
        return sb.toString();
    }

    public void uploadExcelFile(String path) {
        RecordImportServices importServices = new RecordImportServices(this.config);
        String response = importServices.uploadXLSXFile(path);
        if (response == null) {
            System.out.println("Aucune r\u00e9ponse du serveur...");
        } else if (response.contains(this.IMPORT_SUCCESS_RESPONSE)) {
            System.out.println("Les enregistrements ont \u00e9t\u00e9 import\u00e9s avec succ\u00e8s");
            if (this.skippedContents.size() > 0) {
                ClientLogWriter logWriter = new ClientLogWriter(ImportScriptConstants.DATA_FOLDER + LOG_FILE_NAME);
                logWriter.writeSkippedContentsToLogFile(this.skippedContents);
            }
        } else {
            System.out.println("Des erreurs sont survenues lors de l'importation:");
            System.out.println(response);
            ClientLogWriter logWriter = new ClientLogWriter(ImportScriptConstants.DATA_FOLDER + LOG_FILE_NAME);
            logWriter.writeMessageToLogFile(response);
        }
        this.deleteFile(this.getImportableFilePath());
    }

    public boolean validateExcelFile(String tempFilePath) {
        RecordImportServices importServices = new RecordImportServices(this.config);
        String response = importServices.validateXLSXFile(tempFilePath);
        if (response == null) {
            System.out.println("Aucune r\u00e9ponse du serveur...");
        } else {
            if (response.contains(this.IMPORT_SUCCESS_RESPONSE)) {
                this.deleteFile(tempFilePath);
                return true;
            }
            System.out.println(String.format("Des erreurs de validation sont survenues, veuillez consulter le fichier %s pour plus de d\u00e9tails.", LOG_FILE_NAME));
            System.out.println(response);
            ClientLogWriter logWriter = new ClientLogWriter(ImportScriptConstants.DATA_FOLDER + LOG_FILE_NAME);
            logWriter.writeMessageToLogFile(response);
        }
        this.deleteFile(tempFilePath);
        return false;
    }

    private void deleteFile(String path) {
        File file = new File(path);
        file.delete();
    }

    private List<CellContent> getContentsToUpload(File file) {
        System.out.println(String.format("Lecture du fichier %s", file.getName()));
        ArrayList<CellContent> contentList = new ArrayList<CellContent>();
        try {
            Excel2007ImportDataProvider importDataProvider = new Excel2007ImportDataProvider(file);
            importDataProvider.initialize();
            Integer contentColumnPos = this.getContentColumnPosition(importDataProvider);
            if (contentColumnPos != null) {
                ImportDataIterator iterator = importDataProvider.newDataIterator(this.DOCUMENT_SCHEMA_TYPE);
                while (iterator.hasNext()) {
                    ImportData importData = (ImportData)iterator.next();
                    String content = (String)importData.getFields().get(CONTENT_COLUMN_TITLE);
                    int posX = contentColumnPos == null ? importData.getFields().size() : contentColumnPos.intValue();
                    int posY = importData.getIndex();
                    if (this.validateFileExists(content, 3, importData.getLegacyId()) || this.config.isSkipMissingFiles()) {
                        contentList.add(new CellContent(posX, posY, content));
                        continue;
                    }
                    System.out.println(String.format("Fichier manquant \u00e0 la ligne %d", posY));
                    return null;
                }
            }
        }
        catch (Exception e) {
            System.out.println(String.format("Impossible de lire le fichier '%s' V\u00e9rifiez le fichier de configuration.", file));
        }
        return contentList;
    }

    private boolean validateFileExists(String filePath, int nbTriesLeft, String id) {
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                if (nbTriesLeft > 0) {
                    System.out.println(String.format("\tFichier '%s' non-trouv\u00e9. Nouvel essai.", filePath));
                    Thread.sleep(RETRY_FILE_SLEEP_TIME);
                    return this.validateFileExists(filePath, nbTriesLeft - 1, id);
                }
                System.out.println(String.format("Le fichier r\u00e9f\u00e9renc\u00e9 '%s' n'existe pas", filePath));
                this.skippedContents.put(id, filePath);
                return false;
            }
        }
        catch (InterruptedException | NullPointerException e) {
            e.printStackTrace();
            return false;
        }
        if (nbTriesLeft < NB_RETRY_NOT_FOUND_FILES) {
            System.out.println(String.format("\tFichier '%s' trouv\u00e9", filePath));
        }
        return true;
    }

    private Integer getContentColumnPosition(Excel2007ImportDataProvider importDataProvider) {
        try {
            ExcelSheet sheet = importDataProvider.getExcelSheet(this.DOCUMENT_SCHEMA_TYPE);
            for (int i = 0; i <= sheet.getRows(); ++i) {
                int x = 0;
                for (ExcelCell cell : sheet.getRow(i)) {
                    if (cell.getContents().equals(CONTENT_COLUMN_TITLE)) {
                        return x;
                    }
                    ++x;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Le fichier Excel n'a pas de page 'document'");
            ClientLogWriter logWriter = new ClientLogWriter(ImportScriptConstants.DATA_FOLDER + LOG_FILE_NAME);
            logWriter.writeMessageToLogFile("Le fichier Excel n'a pas de page 'document'");
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return null;
    }

    private void deleteNonDocumentSheets(Workbook workbook) {
        Iterator<Sheet> sheetIterator = workbook.sheetIterator();
        int i = 0;
        while (sheetIterator.hasNext()) {
            Sheet sheet = sheetIterator.next();
            if (sheet.getSheetName() != this.DOCUMENT_SCHEMA_TYPE) {
                workbook.removeSheetAt(i);
            }
            ++i;
        }
    }

    private String getValidationFilePath() {
        return this.generateTemplateCopyName(FILE_SUFFIX_VALIDATION);
    }

    private String getImportableFilePath() {
        return this.generateTemplateCopyName(FILE_SUFFIX_IMPORTABLE);
    }

    public File createValidationFile() throws FileNotFoundException {
        File originalFile = new File(this.filePath);
        String validationFilePath = this.getValidationFilePath();
        try {
            FileInputStream inputStream = new FileInputStream(originalFile);
            Workbook workbook = WorkbookFactory.create(inputStream);
            Sheet sheet = workbook.getSheet(this.DOCUMENT_SCHEMA_TYPE);
            Row headerRow = sheet.getRow(1);
            int contentFilePathColumn = -1;
            for (int i = 0; i <= headerRow.getPhysicalNumberOfCells() - 1; ++i) {
                Cell cell = headerRow.getCell(i);
                if (cell == null || !cell.getStringCellValue().startsWith("content")) continue;
                cell.setCellValue("");
                contentFilePathColumn = i;
                break;
            }
            if (contentFilePathColumn > -1) {
                for (Row row : sheet) {
                    Cell cell = row.getCell(contentFilePathColumn);
                    if (cell == null) continue;
                    row.removeCell(row.getCell(contentFilePathColumn));
                }
            }
            FileOutputStream fileOut = new FileOutputStream(validationFilePath);
            workbook.write(fileOut);
            workbook.close();
            fileOut.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new File(validationFilePath);
    }

    private String generateTemplateCopyName(String suffix) {
        StringBuilder newFilePathBuilder = new StringBuilder();
        newFilePathBuilder.append(FilenameUtils.getFullPath(this.filePath)).append(FilenameUtils.getBaseName(this.filePath)).append(".").append(suffix).append(".").append(FilenameUtils.getExtension(this.filePath));
        return newFilePathBuilder.toString();
    }

    public String writeImportableFile(List<CellContent> imported) {
        File originalFile = new File(this.filePath);
        String importableFilePath = this.getImportableFilePath();
        try {
            FileInputStream inputStream = new FileInputStream(originalFile);
            Workbook workbook = WorkbookFactory.create(inputStream);
            Sheet sheet = workbook.getSheet(this.DOCUMENT_SCHEMA_TYPE);
            this.deleteBlankRows(sheet);
            if (imported.size() > 0) {
                int contentColumn = imported.get(0).getX();
                Cell headerCell = sheet.getRow(1).getCell(contentColumn);
                headerCell.setCellValue("content\ntype=filename:hash");
            }
            for (CellContent content : imported) {
                Cell cell;
                Row row = sheet.getRow(content.getY());
                if (row == null || (cell = sheet.getRow(content.getY()).getCell(content.getX())) == null) continue;
                String filePath = cell.getStringCellValue();
                File tempFile = new File(filePath);
                String filename = tempFile.getName();
                String hash = content.getCellValue();
                if (StringUtils.isNotBlank(hash)) {
                    cell.setCellValue(filename + ":" + hash);
                    continue;
                }
                cell.setCellValue("");
            }
            FileOutputStream fileOut = new FileOutputStream(importableFilePath);
            workbook.write(fileOut);
            workbook.close();
            fileOut.close();
        }
        catch (IOException e) {
            System.out.print("\nImpossible de cr\u00e9er une copie du fichier Excel.\nAssurez-vous que le fichier n'est pas ouvert dans un autre programme.");
            e.printStackTrace();
            return null;
        }
        return importableFilePath;
    }

    private void deleteBlankRows(Sheet sheet) {
        boolean nonEmptyRowFound = false;
        block0: while (!nonEmptyRowFound) {
            Row lastRow = sheet.getRow(sheet.getLastRowNum());
            for (int i = lastRow.getFirstCellNum(); i <= lastRow.getLastCellNum(); ++i) {
                if (!lastRow.getCell(i).getCellType().equals((Object)CellType.BLANK)) {
                    nonEmptyRowFound = true;
                    continue block0;
                }
                sheet.removeRow(lastRow);
            }
        }
    }

    private String readConfig(String key) {
        Properties properties = new Properties();
        try {
            StringBuilder configPathBuilder = new StringBuilder();
            configPathBuilder.append(".\\").append(ImportScriptConstants.CONFIGURATIONS_FOLDER).append("\\").append(ImportScriptConstants.CONFIG_FILE_NAME);
            FileInputStream configFileStream = new FileInputStream(configPathBuilder.toString());
            properties.load(new InputStreamReader((InputStream)configFileStream, Charset.forName("UTF8")));
            return properties.getProperty(key);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public HashMap<String, String> getSkippedContents() {
        return this.skippedContents;
    }
}

