/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.importscript;

import com.constellio.plugin050.importscript.HttpConfigurations;
import com.constellio.plugin050.importscript.exceptions.ServerUnavailableException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class RecordImportServices {
    public static final String COLLECTION = "collection";
    public static final String USERNAME = "username";
    public static final String TOKEN_OR_PASSWORD = "token";
    public static final String SERVICEKEY = "serviceKey";
    public static final String SIMULATE_IMPORT = "simulate";
    private HttpConfigurations config;

    public RecordImportServices(HttpConfigurations config) {
        this.config = config;
    }

    public String callService(String servletPath, Map<String, Object> inParams, boolean timeout) {
        HttpURLConnection outConnection = this.setupConnection(servletPath, false);
        Boolean isSimulate = (Boolean)inParams.get(SIMULATE_IMPORT);
        try {
            String response;
            outConnection.setRequestMethod("POST");
            outConnection.setRequestProperty("content-type", "multipart/form-com.constellio.plugin050.data");
            outConnection.setDoInput(true);
            outConnection.setDoOutput(true);
            outConnection.setUseCaches(false);
            outConnection.setDefaultUseCaches(false);
            outConnection.addRequestProperty("dataType", (String)inParams.get("dataType"));
            outConnection.addRequestProperty(USERNAME, this.config.getUsername());
            outConnection.addRequestProperty(TOKEN_OR_PASSWORD, this.config.getToken());
            outConnection.addRequestProperty(COLLECTION, this.config.getCollection());
            outConnection.addRequestProperty(SERVICEKEY, this.config.getServiceKey());
            outConnection.addRequestProperty(SIMULATE_IMPORT, String.valueOf(isSimulate));
            outConnection.setDoOutput(true);
            File fileToSend = new File((String)inParams.get("importFile"));
            if (fileToSend != null) {
                byte[] file = IOUtils.toByteArray(fileToSend.toURI());
                outConnection.getOutputStream().write(file);
            }
            outConnection.connect();
            int responseCode = outConnection.getResponseCode();
            if (responseCode == 200) {
                byte[] responseBytes = IOUtils.toByteArray(outConnection.getInputStream());
                response = new String(responseBytes, "ISO-8859-1");
            } else {
                byte[] responseBytes = IOUtils.toByteArray(outConnection.getErrorStream());
                response = new String(responseBytes, "ISO-8859-1");
            }
            return response;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String readResponse(InputStream inputStream) throws IOException {
        String output;
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        while ((output = br.readLine()) != null) {
            sb.append(output);
        }
        return sb.toString();
    }

    private HttpURLConnection setupConnection(String servletPath, boolean timeout) {
        String baseURL = this.config.getAdress();
        if (baseURL == null) {
            throw new ServerUnavailableException();
        }
        HttpURLConnection outConnection = null;
        try {
            if (!baseURL.endsWith("/")) {
                baseURL = baseURL + "/";
            }
            baseURL = baseURL + "rm";
            URL serviceURL = new URL(baseURL + servletPath);
            try {
                outConnection = (HttpURLConnection)serviceURL.openConnection();
                if (timeout) {
                    outConnection.setConnectTimeout(2000);
                }
                return outConnection;
            }
            catch (Throwable t) {
                throw new ServerUnavailableException(t);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String validateXLSXFile(String file) {
        HashMap<String, Object> inParams = new HashMap<String, Object>();
        inParams.put("importFile", file);
        inParams.put("dataType", "xlsx");
        inParams.put(SIMULATE_IMPORT, true);
        String response = this.callService("/importRecords", inParams, true);
        return this.isResponseHtml(response) ? null : response;
    }

    public String uploadXLSXFile(String file) {
        HashMap<String, Object> inParams = new HashMap<String, Object>();
        inParams.put("importFile", file);
        inParams.put("dataType", "xlsx");
        String response = this.callService("/importRecords", inParams, true);
        return this.isResponseHtml(response) ? null : response;
    }

    private boolean isResponseHtml(String response) {
        String HTML_PATTERN = "<!doctype html>";
        return response.startsWith(HTML_PATTERN);
    }
}

