/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.importscript.data.excel;

import com.constellio.plugin050.importscript.data.batchImport.ImportData;
import com.constellio.plugin050.importscript.data.batchImport.ImportDataIterator;
import com.constellio.plugin050.importscript.data.batchImport.ImportDataIteratorRuntimeException;
import com.constellio.plugin050.importscript.data.batchImport.ImportDataOptions;
import com.constellio.plugin050.importscript.data.excel.ExcelCell;
import com.constellio.plugin050.importscript.data.excel.ExcelDataType;
import com.constellio.plugin050.importscript.data.excel.ExcelSheet;
import com.constellio.plugin050.importscript.data.util.LazyIterator;
import com.constellio.plugin050.importscript.data.util.SimpleImportContent;
import com.constellio.plugin050.importscript.data.util.TimeProvider;
import com.drew.metadata.MetadataException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class ExcelImportDataIterator
extends LazyIterator<ImportData>
implements ImportDataIterator {
    public static final String ID_ATTR = "id";
    public static final String SCHEMA_ATTR = "schema";
    public static final String PATTERN = "pattern";
    public static final String SEPARATOR = "separator";
    public static final String DATE = "date";
    public static final String DEFAULT_SCHEMA = "default";
    private static final String DATETIME_VALUE = "datetime";
    private static final String DATE_VALUE = "date";
    public static final String STRUCTURE = "structure";
    public static final String ITEM = "item";
    public static final String MULTILINE = "multiline";
    public static final String LEGACY_ID = "importAsLegacyId";
    public static final String SYNCHRONIZE_FILENAME = "useTitleAsFilename";
    public static final String FILENAME_HASH_CONTENT = "filename:hash";
    public static final String IMPORT_WITH_WHITESPACE = "keepExtraWhitespace";
    public static final String CELL_RANGE_PREFIX = "cellRange";
    public static final String CELL_RANGE_BEGIN_DELIMITER = "[";
    public static final String CELL_RANGE_END_DELIMITER = "]";
    private ExcelSheet sheet;
    private int lineToParse = 1;
    private List<ExcelDataType> types;
    private ImportDataOptions options;

    public ExcelImportDataIterator(ExcelSheet sheet) {
        this.sheet = sheet;
        this.types = new ArrayList<ExcelDataType>();
        this.options = new ImportDataOptions();
        this.initialize();
    }

    private void initialize() {
        for (ExcelCell cell : this.sheet.getRow(1)) {
            if (this.nullOrInvalidData(cell.getContents())) continue;
            try {
                this.types.add(this.parseCellTypeLine(cell));
            }
            catch (MetadataException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public ImportDataOptions getOptions() {
        return this.options;
    }

    @Override
    public void close() {
    }

    @Override
    protected ImportData getNextOrNull() {
        ++this.lineToParse;
        if (this.lineToParse == this.sheet.getRows()) {
            return null;
        }
        try {
            while (this.lineIsEmpty()) {
                ++this.lineToParse;
                if (this.lineToParse != this.sheet.getRows()) continue;
                return null;
            }
            return this.parseRecord();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public ExcelDataType parseCellTypeLine(ExcelCell cell) throws MetadataException {
        String cellContent = cell.getContents();
        ExcelDataType dataType = new ExcelDataType();
        if (!cellContent.contains("\n")) {
            dataType.setTypeName(cellContent);
        } else {
            String[] metadatas = cellContent.split("\\n");
            dataType.setTypeName(metadatas[0]);
            for (int index = 1; index < metadatas.length; ++index) {
                String line = metadatas[index];
                if (line.contains("date") || line.contains(PATTERN) || line.contains(SEPARATOR) || line.contains(STRUCTURE) || line.contains(ITEM) || line.contains(MULTILINE) || line.contains(LEGACY_ID) || line.contains(FILENAME_HASH_CONTENT) || line.contains(SYNCHRONIZE_FILENAME) || line.contains(IMPORT_WITH_WHITESPACE)) {
                    if (line.contains("date")) {
                        String dateValue = this.parseEnteredDataTypeValue(line);
                        dataType.setDateType(dateValue);
                        if (metadatas[++index].contains(PATTERN)) {
                            dataType.setDatePattern(this.splitDateFormat(metadatas[index]));
                        }
                    } else if (line.contains(PATTERN)) {
                        dataType.setDataPattern(line.replace("pattern=", ""));
                    } else if (line.contains(STRUCTURE)) {
                        dataType.setStructure(line.replace("structure=", ""));
                    } else if (line.contains(ITEM)) {
                        dataType.setItem(line.replace("item=", ""));
                    } else if (line.contains(MULTILINE)) {
                        dataType.setMultiline(true);
                    } else if (line.contains(FILENAME_HASH_CONTENT)) {
                        dataType.setFilenameHashImport(true);
                    } else if (line.contains(LEGACY_ID)) {
                        boolean isLegacyId = this.parseEnteredTypeBooleanValue(line);
                        this.options.setImportAsLegacyId(isLegacyId);
                    } else if (line.contains(SYNCHRONIZE_FILENAME) && "title".equals(dataType.getTypeName())) {
                        boolean synchronizeFilenames = this.parseEnteredTypeBooleanValue(line);
                        this.options.setSynchronizeFilename(synchronizeFilenames);
                    }
                    if (line.contains(IMPORT_WITH_WHITESPACE)) {
                        dataType.setImportWhiteSpace(true);
                    }
                    if (!line.contains(SEPARATOR)) continue;
                    dataType.setSeparator(this.parseEnteredDataTypeValue(line));
                    continue;
                }
                throw new MetadataException("The file contains invalid metadatas on column type: " + StringUtils.defaultIfBlank(line, ""));
            }
        }
        return dataType;
    }

    private boolean parseEnteredTypeBooleanValue(String line) {
        return this.parseEnteredDataTypeValue(line).equalsIgnoreCase("true");
    }

    private String parseEnteredDataTypeValue(String line) {
        String[] splitDatas = line.split("=", 2);
        return splitDatas[splitDatas.length - 1];
    }

    public ImportData parseRecord() {
        String schema = null;
        HashMap<String, Object> fields = new HashMap<String, Object>();
        String legacy = null;
        for (ExcelCell cell : this.sheet.getRow(this.lineToParse)) {
            ExcelDataType currentType;
            try {
                currentType = this.types.get(cell.getColumn());
            }
            catch (IndexOutOfBoundsException e) {
                currentType = null;
            }
            if (currentType != null) {
                switch (currentType.getTypeName()) {
                    case "id": {
                        legacy = StringUtils.trim(cell.getContents());
                        break;
                    }
                    case "schema": {
                        if (!cell.isNotEmpty()) break;
                        schema = cell.getContents();
                        break;
                    }
                    default: {
                        if (currentType.getStructure() != null) {
                            List structure = (List)fields.get(currentType.getStructure());
                            fields.put(currentType.getStructure(), this.createOrUpdateStructureContent(currentType, structure, cell));
                            break;
                        }
                        fields.put(this.types.get(cell.getColumn()).getTypeName(), this.parseCell(cell, this.types.get(cell.getColumn())));
                    }
                }
            }
            if (cell.getColumn() != this.types.size()) continue;
            break;
        }
        for (ExcelDataType type : this.types) {
            Map itemStructure;
            if (fields.containsKey(type.getTypeName())) continue;
            if (type.getStructure() == null) {
                if (type.getSeparator() != null) {
                    fields.put(type.getTypeName(), new ArrayList());
                    continue;
                }
                fields.put(type.getTypeName(), null);
                continue;
            }
            List structure = (List)fields.get(type.getStructure());
            if (structure.size() < type.getItem() || structure.isEmpty() || type.getItem() <= 0 || (itemStructure = (Map)structure.get(type.getItem() - 1)).containsKey(type.getTypeName())) continue;
            itemStructure.put(type.getTypeName(), null);
        }
        if (fields.containsKey(ID_ATTR)) {
            fields.remove(ID_ATTR);
        }
        if (fields.containsKey(SCHEMA_ATTR)) {
            fields.remove(SCHEMA_ATTR);
        }
        return new ImportData(this.lineToParse, schema, legacy, fields);
    }

    private List<Map<String, String>> createOrUpdateStructureContent(ExcelDataType currentType, List<Map<String, String>> structure, ExcelCell cell) {
        List<Map<String, String>> list = structure = structure != null ? structure : new ArrayList<Map<String, String>>();
        if (currentType.isMultiline() && currentType.getSeparator() != null) {
            structure = this.createMultilineSubStructure(currentType, cell);
        } else {
            Map<String, String> itemStructure = this.createUpdateItemSubStructure(currentType, cell, structure);
            if (structure.indexOf(itemStructure) != -1) {
                structure.set(currentType.getItem() - 1, itemStructure);
            } else {
                structure.add(itemStructure);
            }
        }
        return structure;
    }

    private List<Map<String, String>> createMultilineSubStructure(ExcelDataType currentType, ExcelCell cell) {
        ArrayList<Map<String, String>> structure = new ArrayList<Map<String, String>>();
        String[] metadataNames = currentType.getTypeName().split(currentType.getSeparator());
        String[] lines = cell.getContents().split("\n");
        for (int i = 0; i < lines.length; ++i) {
            HashMap<String, String> subStructure = new HashMap<String, String>();
            if (!StringUtils.isNotBlank(lines[i])) continue;
            String[] values = lines[i].split(currentType.getSeparator());
            for (int j = 0; j < values.length; ++j) {
                subStructure.put(metadataNames[j], values[j]);
            }
            structure.add(subStructure);
        }
        return structure;
    }

    private Map<String, String> createUpdateItemSubStructure(ExcelDataType currentType, ExcelCell cell, List<Map<String, String>> structure) {
        Map<String, String> itemStructure = structure.size() >= currentType.getItem() && !structure.isEmpty() ? structure.get(currentType.getItem() - 1) : new HashMap<String, String>();
        itemStructure.put(currentType.getTypeName(), this.convertToStructure(this.parseCell(cell, this.types.get(cell.getColumn()))));
        return itemStructure;
    }

    private String convertToStructure(Object value) {
        if (value instanceof List) {
            StringBuilder builder = new StringBuilder();
            Iterator iterator = ((List)value).iterator();
            while (iterator.hasNext()) {
                builder.append(String.valueOf(iterator.next()).replace("code:", ""));
                if (!iterator.hasNext()) continue;
                builder.append(",");
            }
            return builder.toString();
        }
        return value != null ? String.valueOf(value) : null;
    }

    private boolean lineIsEmpty() {
        for (ExcelCell cell : this.sheet.getRow(this.lineToParse)) {
            if (!cell.isNotEmpty() || this.nullOrInvalidData(cell.getContents())) continue;
            return false;
        }
        return true;
    }

    private boolean nullOrInvalidData(String content) {
        return content == null || content.equals("") || content.equals(" ") || content.equals("\n") || content.equals("null");
    }

    public Object parseCell(ExcelCell cell, ExcelDataType type) {
        if (type.getSeparator() != null) {
            return this.parseCellWithMultiValue(cell, type);
        }
        return this.parseCellWithSimpleValue(cell, type);
    }

    private Object parseCellWithSimpleValue(ExcelCell cell, ExcelDataType type) {
        String cellContent = cell.getContents();
        if (cell.isDate()) {
            Date date = cell.getDate();
            DateTime dateTime = new DateTime(date).withZone(DateTimeZone.UTC);
            if ("dateTime".equals(type.getDateType())) {
                return dateTime.toLocalDateTime();
            }
            return dateTime.toLocalDate();
        }
        return this.readValue(cellContent, type);
    }

    public Object parseCellWithMultiValue(ExcelCell cell, ExcelDataType cellType) {
        String[] multivalueContent;
        String cellContent = cell.getContents();
        ArrayList<Object> datas = new ArrayList<Object>();
        for (String value : multivalueContent = cellContent.split(cellType.getSeparator())) {
            datas.add(this.readValue(value, cellType));
        }
        return this.validatedList(datas);
    }

    private Object validatedList(List<Object> datas) {
        ArrayList<Object> garbage = new ArrayList<Object>();
        for (Object content : datas) {
            if ((!(content instanceof String) || !this.nullOrInvalidData((String)content)) && content != null) continue;
            garbage.add(content);
        }
        datas.removeAll(garbage);
        return datas;
    }

    public Object readValue(String value, ExcelDataType type) {
        if (this.nullOrInvalidData(value)) {
            return null;
        }
        if (!type.isImportWhiteSpaceEnabled()) {
            value = StringUtils.trim(value);
        }
        if (type.getDatePattern() != null) {
            return this.formatDateString(value, type);
        }
        if (type.getDataPattern() != null) {
            return type.getDataPattern() + ":" + value;
        }
        if (type.isFilenameHashImport() && StringUtils.isNotBlank(value) && value.contains(":")) {
            String[] parts = value.split(":");
            return new SimpleImportContent("hash:" + parts[1], parts[0], true, TimeProvider.getLocalDateTime());
        }
        return value;
    }

    public Object formatDateString(String value, ExcelDataType type) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.forPattern(type.getDatePattern());
        switch (type.getDateType()) {
            case "date": {
                try {
                    return dateTimeFormatter.parseLocalDate(value);
                }
                catch (IllegalArgumentException e) {
                    throw new ImportDataIteratorRuntimeException.ImportDataIteratorRuntimeException_InvalidDate(type.getDatePattern(), value);
                }
            }
            case "datetime": {
                try {
                    return dateTimeFormatter.parseLocalDateTime(value);
                }
                catch (IllegalArgumentException e) {
                    throw new ImportDataIteratorRuntimeException.ImportDataIteratorRuntimeException_InvalidDate(type.getDatePattern(), value);
                }
            }
        }
        throw new ImportDataIteratorRuntimeException.ImportDataIteratorRuntimeException_InvalidDate(type.getDatePattern(), value);
    }

    public String splitDateFormat(String line) {
        String[] splitLine = line.split("\\n");
        String dateFormat = null;
        for (String s : splitLine) {
            if (!s.contains(PATTERN)) continue;
            String[] splitDatePatternLine = s.split("\\=");
            dateFormat = splitDatePatternLine[splitDatePatternLine.length - 1];
        }
        return dateFormat;
    }
}

