/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.util;

import com.constellio.plugin050.importscript.HttpConfigurations;
import com.constellio.plugin050.util.ImportScriptConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Properties;

public class ImportConfigurationsManager {
    private File configFile;
    private FileInputStream configFileStream;

    public ImportConfigurationsManager(File configurationsFile) {
        this.configFile = configurationsFile;
    }

    public ImportConfigurationsManager() {
    }

    public String readProperty(String key) {
        Properties properties = new Properties();
        try {
            FileInputStream configFileStream = new FileInputStream(this.configFile);
            properties.load(new InputStreamReader((InputStream)configFileStream, Charset.forName("UTF8")));
            String value = properties.getProperty(key);
            if (value.isEmpty() || value == null) {
                return null;
            }
            return value;
        }
        catch (IOException | NullPointerException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void writeProperty(String key, String value) {
        System.out.println(String.format(String.format("Mise \u00e0 jour du fichier de configuration: %s", key), new Object[0]));
        Properties properties = new Properties();
        try {
            FileInputStream configFileStream = new FileInputStream(this.configFile);
            properties.load(new InputStreamReader((InputStream)configFileStream, Charset.forName("UTF8")));
            properties.setProperty(key, value);
            FileOutputStream out = new FileOutputStream(this.configFile);
            properties.store(out, null);
            out.close();
        }
        catch (IOException e) {
            System.out.println("Une erreur est survenue lors de l'\u00e9criture du fichier de configurations.");
            e.printStackTrace();
        }
    }

    public HttpConfigurations loadConfigFile(String configFileName) {
        if (ImportConfigurationsManager.configFileExists(configFileName)) {
            this.configFile = new File(configFileName);
            String host = this.readProperty(ImportScriptConstants.CONFIG_HOST);
            String port = this.readProperty(ImportScriptConstants.CONFIG_PORT);
            Boolean useSSL = Boolean.valueOf(this.readProperty(ImportScriptConstants.CONFIG_USE_SSL));
            Boolean trustAllCertificatres = Boolean.valueOf(this.readProperty(ImportScriptConstants.CONFIG_TRUST_ALL_CERTIFICATES));
            Boolean skipMissingFiles = Boolean.valueOf(this.readProperty(ImportScriptConstants.CONFIG_IMPORT_SKIP_MISSING_FILES));
            Boolean withConnectionTimeout = Boolean.valueOf(this.readProperty(ImportScriptConstants.CONFIG_IMPORT_WITH_CONNECTION_TIMEOUT));
            String collection = this.readProperty(ImportScriptConstants.CONFIG_IMPORT_COLLECTION);
            HttpConfigurations config = new HttpConfigurations(host, port);
            config.setCollection(collection);
            config.setConfigFile(this.configFile);
            config.setConnectUsingSSL(useSSL);
            config.setTrustAllCertificates(trustAllCertificatres);
            config.setSkipMissingFiles(skipMissingFiles);
            config.setWithConnectionTimeout(withConnectionTimeout);
            return config;
        }
        return null;
    }

    public void createNewConfigFile(HttpConfigurations config, String configFileName) {
        System.out.println("\u00c9criture d'un nouveau fichier de configurations.");
        try {
            PrintWriter writer = new PrintWriter(configFileName, "UTF-8");
            writer.println(ImportScriptConstants.CONFIG_HOST + "=" + config.getHost());
            writer.println(ImportScriptConstants.CONFIG_PORT + "=" + config.getPort());
            writer.println(ImportScriptConstants.CONFIG_IMPORT_COLLECTION + "=" + config.getCollection());
            writer.close();
            File configFile = new File(configFileName);
            System.out.println(String.format("Un nouveau fichier de configuration a \u00e9t\u00e9 cr\u00e9\u00e9 dans le dossier %s", configFile.getAbsolutePath()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean configFileExists(String configFileName) {
        try {
            new FileInputStream(configFileName);
            File configFile = new File(configFileName);
            System.out.println(configFile.getAbsolutePath());
            return true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }
}

