/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.encoding;

import com.sun.corba.se.impl.encoding.CodeSetCache;
import com.sun.corba.se.impl.encoding.CodeSetComponentInfo;
import com.sun.corba.se.impl.encoding.OSFCodeSetRegistry;
import com.sun.corba.se.impl.logging.OMGSystemException;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;

public class CodeSetConversion {
    private static CodeSetConversion implementation;
    private static final int FALLBACK_CODESET = 0;
    private CodeSetCache cache = new CodeSetCache();

    public CTBConverter getCTBConverter(OSFCodeSetRegistry.Entry entry) {
        int n = !entry.isFixedWidth() ? 1 : entry.getMaxBytesPerChar();
        return new JavaCTBConverter(entry, n);
    }

    public CTBConverter getCTBConverter(OSFCodeSetRegistry.Entry entry, boolean bl, boolean bl2) {
        if (entry == OSFCodeSetRegistry.UCS_2) {
            return new UTF16CTBConverter(bl);
        }
        if (entry == OSFCodeSetRegistry.UTF_16) {
            if (bl2) {
                return new UTF16CTBConverter();
            }
            return new UTF16CTBConverter(bl);
        }
        int n = !entry.isFixedWidth() ? 1 : entry.getMaxBytesPerChar();
        return new JavaCTBConverter(entry, n);
    }

    public BTCConverter getBTCConverter(OSFCodeSetRegistry.Entry entry) {
        return new JavaBTCConverter(entry);
    }

    public BTCConverter getBTCConverter(OSFCodeSetRegistry.Entry entry, boolean bl) {
        if (entry == OSFCodeSetRegistry.UTF_16 || entry == OSFCodeSetRegistry.UCS_2) {
            return new UTF16BTCConverter(bl);
        }
        return new JavaBTCConverter(entry);
    }

    private int selectEncoding(CodeSetComponentInfo.CodeSetComponent codeSetComponent, CodeSetComponentInfo.CodeSetComponent codeSetComponent2) {
        int n;
        int n2 = codeSetComponent2.nativeCodeSet;
        if (n2 == 0) {
            if (codeSetComponent2.conversionCodeSets.length > 0) {
                n2 = codeSetComponent2.conversionCodeSets[0];
            } else {
                return 0;
            }
        }
        if (codeSetComponent.nativeCodeSet == n2) {
            return n2;
        }
        for (n = 0; n < codeSetComponent.conversionCodeSets.length; ++n) {
            if (n2 != codeSetComponent.conversionCodeSets[n]) continue;
            return n2;
        }
        for (n = 0; n < codeSetComponent2.conversionCodeSets.length; ++n) {
            if (codeSetComponent.nativeCodeSet != codeSetComponent2.conversionCodeSets[n]) continue;
            return codeSetComponent.nativeCodeSet;
        }
        for (n = 0; n < codeSetComponent2.conversionCodeSets.length; ++n) {
            for (int i = 0; i < codeSetComponent.conversionCodeSets.length; ++i) {
                if (codeSetComponent2.conversionCodeSets[n] != codeSetComponent.conversionCodeSets[i]) continue;
                return codeSetComponent2.conversionCodeSets[n];
            }
        }
        return 0;
    }

    public CodeSetComponentInfo.CodeSetContext negotiate(CodeSetComponentInfo codeSetComponentInfo, CodeSetComponentInfo codeSetComponentInfo2) {
        int n;
        int n2 = this.selectEncoding(codeSetComponentInfo.getCharComponent(), codeSetComponentInfo2.getCharComponent());
        if (n2 == 0) {
            n2 = OSFCodeSetRegistry.UTF_8.getNumber();
        }
        if ((n = this.selectEncoding(codeSetComponentInfo.getWCharComponent(), codeSetComponentInfo2.getWCharComponent())) == 0) {
            n = OSFCodeSetRegistry.UTF_16.getNumber();
        }
        return new CodeSetComponentInfo.CodeSetContext(n2, n);
    }

    private CodeSetConversion() {
    }

    public static final CodeSetConversion impl() {
        return CodeSetConversionHolder.csc;
    }

    private static class CodeSetConversionHolder {
        static final CodeSetConversion csc = new CodeSetConversion();

        private CodeSetConversionHolder() {
        }
    }

    private class UTF16BTCConverter
    extends JavaBTCConverter {
        private boolean defaultToLittleEndian;
        private boolean converterUsesBOM;
        private static final char UTF16_BE_MARKER = '\ufeff';
        private static final char UTF16_LE_MARKER = '\ufffe';

        public UTF16BTCConverter(boolean bl) {
            super(OSFCodeSetRegistry.UTF_16);
            this.converterUsesBOM = true;
            this.defaultToLittleEndian = bl;
        }

        @Override
        public char[] getChars(byte[] byArray, int n, int n2) {
            if (this.hasUTF16ByteOrderMarker(byArray, n, n2)) {
                if (!this.converterUsesBOM) {
                    this.switchToConverter(OSFCodeSetRegistry.UTF_16);
                }
                this.converterUsesBOM = true;
                return super.getChars(byArray, n, n2);
            }
            if (this.converterUsesBOM) {
                if (this.defaultToLittleEndian) {
                    this.switchToConverter(OSFCodeSetRegistry.UTF_16LE);
                } else {
                    this.switchToConverter(OSFCodeSetRegistry.UTF_16BE);
                }
                this.converterUsesBOM = false;
            }
            return super.getChars(byArray, n, n2);
        }

        private boolean hasUTF16ByteOrderMarker(byte[] byArray, int n, int n2) {
            if (n2 >= 4) {
                int n3 = byArray[n] & 0xFF;
                int n4 = byArray[n + 1] & 0xFF;
                char c = (char)(n3 << 8 | n4 << 0);
                return c == '\ufeff' || c == '\ufffe';
            }
            return false;
        }

        private void switchToConverter(OSFCodeSetRegistry.Entry entry) {
            this.btc = super.getConverter(entry.getName());
        }
    }

    private class JavaBTCConverter
    extends BTCConverter {
        private ORBUtilSystemException wrapper = ORBUtilSystemException.get("rpc.encoding");
        private OMGSystemException omgWrapper = OMGSystemException.get("rpc.encoding");
        protected CharsetDecoder btc;
        private char[] buffer;
        private int resultingNumChars;
        private OSFCodeSetRegistry.Entry codeset;

        public JavaBTCConverter(OSFCodeSetRegistry.Entry entry) {
            this.btc = this.getConverter(entry.getName());
            this.codeset = entry;
        }

        @Override
        public final boolean isFixedWidthEncoding() {
            return this.codeset.isFixedWidth();
        }

        @Override
        public final int getFixedCharWidth() {
            return this.codeset.getMaxBytesPerChar();
        }

        @Override
        public final int getNumChars() {
            return this.resultingNumChars;
        }

        @Override
        public char[] getChars(byte[] byArray, int n, int n2) {
            try {
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
                CharBuffer charBuffer = this.btc.decode(byteBuffer);
                this.resultingNumChars = charBuffer.limit();
                if (charBuffer.limit() == charBuffer.capacity()) {
                    this.buffer = charBuffer.array();
                } else {
                    this.buffer = new char[charBuffer.limit()];
                    charBuffer.get(this.buffer, 0, charBuffer.limit()).position(0);
                }
                return this.buffer;
            }
            catch (IllegalStateException illegalStateException) {
                throw this.wrapper.btcConverterFailure(illegalStateException);
            }
            catch (MalformedInputException malformedInputException) {
                throw this.wrapper.badUnicodePair(malformedInputException);
            }
            catch (UnmappableCharacterException unmappableCharacterException) {
                throw this.omgWrapper.charNotInCodeset(unmappableCharacterException);
            }
            catch (CharacterCodingException characterCodingException) {
                throw this.wrapper.btcConverterFailure(characterCodingException);
            }
        }

        protected CharsetDecoder getConverter(String string) {
            CharsetDecoder charsetDecoder = null;
            try {
                charsetDecoder = CodeSetConversion.this.cache.getByteToCharConverter(string);
                if (charsetDecoder == null) {
                    Charset charset = Charset.forName(string);
                    charsetDecoder = charset.newDecoder();
                    CodeSetConversion.this.cache.setConverter((Object)string, charsetDecoder);
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                throw this.wrapper.invalidBtcConverterName(illegalCharsetNameException, (Object)string);
            }
            return charsetDecoder;
        }
    }

    private class UTF16CTBConverter
    extends JavaCTBConverter {
        public UTF16CTBConverter() {
            super(OSFCodeSetRegistry.UTF_16, 2);
        }

        public UTF16CTBConverter(boolean bl) {
            super(bl ? OSFCodeSetRegistry.UTF_16LE : OSFCodeSetRegistry.UTF_16BE, 2);
        }
    }

    private class JavaCTBConverter
    extends CTBConverter {
        private ORBUtilSystemException wrapper = ORBUtilSystemException.get("rpc.encoding");
        private OMGSystemException omgWrapper = OMGSystemException.get("rpc.encoding");
        private CharsetEncoder ctb;
        private int alignment;
        private char[] chars = null;
        private int numBytes = 0;
        private int numChars = 0;
        private ByteBuffer buffer;
        private OSFCodeSetRegistry.Entry codeset;

        public JavaCTBConverter(OSFCodeSetRegistry.Entry entry, int n) {
            try {
                this.ctb = CodeSetConversion.this.cache.getCharToByteConverter(entry.getName());
                if (this.ctb == null) {
                    Charset charset = Charset.forName(entry.getName());
                    this.ctb = charset.newEncoder();
                    CodeSetConversion.this.cache.setConverter((Object)entry.getName(), this.ctb);
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                throw this.wrapper.invalidCtbConverterName(illegalCharsetNameException, (Object)entry.getName());
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                throw this.wrapper.invalidCtbConverterName(unsupportedCharsetException, (Object)entry.getName());
            }
            this.codeset = entry;
            this.alignment = n;
        }

        @Override
        public final float getMaxBytesPerChar() {
            return this.ctb.maxBytesPerChar();
        }

        @Override
        public void convert(char c) {
            if (this.chars == null) {
                this.chars = new char[1];
            }
            this.chars[0] = c;
            this.numChars = 1;
            this.convertCharArray();
        }

        @Override
        public void convert(String string) {
            if (this.chars == null || this.chars.length < string.length()) {
                this.chars = new char[string.length()];
            }
            this.numChars = string.length();
            string.getChars(0, this.numChars, this.chars, 0);
            this.convertCharArray();
        }

        @Override
        public final int getNumBytes() {
            return this.numBytes;
        }

        @Override
        public final int getAlignment() {
            return this.alignment;
        }

        @Override
        public final boolean isFixedWidthEncoding() {
            return this.codeset.isFixedWidth();
        }

        @Override
        public byte[] getBytes() {
            return this.buffer.array();
        }

        private void convertCharArray() {
            try {
                this.buffer = this.ctb.encode(CharBuffer.wrap(this.chars, 0, this.numChars));
                this.numBytes = this.buffer.limit();
            }
            catch (IllegalStateException illegalStateException) {
                throw this.wrapper.ctbConverterFailure(illegalStateException);
            }
            catch (MalformedInputException malformedInputException) {
                throw this.wrapper.badUnicodePair(malformedInputException);
            }
            catch (UnmappableCharacterException unmappableCharacterException) {
                throw this.omgWrapper.charNotInCodeset(unmappableCharacterException);
            }
            catch (CharacterCodingException characterCodingException) {
                throw this.wrapper.ctbConverterFailure(characterCodingException);
            }
        }
    }

    public static abstract class BTCConverter {
        public abstract boolean isFixedWidthEncoding();

        public abstract int getFixedCharWidth();

        public abstract int getNumChars();

        public abstract char[] getChars(byte[] var1, int var2, int var3);
    }

    public static abstract class CTBConverter {
        public abstract void convert(char var1);

        public abstract void convert(String var1);

        public abstract int getNumBytes();

        public abstract float getMaxBytesPerChar();

        public abstract boolean isFixedWidthEncoding();

        public abstract int getAlignment();

        public abstract byte[] getBytes();
    }
}

