/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.networkShareConversion;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.lang3.StringUtils;

public class FileSystemParser {
    private String rootPath;
    private Collection<File> directories;
    private Collection<File> files;

    public FileSystemParser(String rootPath) {
        String formatedRootPath = StringUtils.removeEnd(rootPath, "/");
        this.rootPath = formatedRootPath = StringUtils.removeEnd(formatedRootPath, "\\");
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public Collection<File> getDirectories() {
        return this.directories;
    }

    public Collection<File> getFiles() {
        return this.files;
    }

    public void parse() {
        System.out.println("Parcours du partage r\u00e9seau...");
        File temp = new File(this.rootPath);
        Collection<File> filesAndDirs = FileUtils.listFilesAndDirs(temp, FileFilterUtils.trueFileFilter(), FileFilterUtils.trueFileFilter());
        this.directories = FileSystemParser.filterDirs(filesAndDirs);
        this.files = FileSystemParser.filterFiles(filesAndDirs);
    }

    public void listFiles() {
        for (File file : this.files) {
            System.out.println(file);
        }
    }

    public void listDirectories() {
        for (File dir : this.directories) {
            System.out.println(dir);
        }
    }

    private static Collection<File> filterFiles(Collection<File> filesAndDirs) {
        ArrayList<File> files = new ArrayList<File>();
        for (File file : filesAndDirs) {
            if (!file.isFile()) continue;
            files.add(file);
        }
        return files;
    }

    private static Collection<File> filterDirs(Collection<File> filesAndDirs) {
        ArrayList<File> dirs = new ArrayList<File>();
        for (File file : filesAndDirs) {
            if (file.isFile()) continue;
            dirs.add(file);
        }
        return dirs;
    }
}

