/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.networkShareConversion;

import com.constellio.plugin050.networkShareConversion.FileSystemConverter;
import com.constellio.plugin050.networkShareConversion.wrappers.DocumentWrapper;
import com.constellio.plugin050.networkShareConversion.wrappers.FolderWrapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class FileSystemExportWriter {
    private File templateFile;
    private XSSFWorkbook workbook;
    private FileSystemConverter converter;
    private static final String FOLDERS_PAGE_NAME = "folder";
    private static final String DOCUMENT_PAGE_NAME = "document";

    public FileSystemExportWriter(FileSystemConverter converter, File templateFile) {
        this.converter = converter;
        this.templateFile = templateFile;
    }

    public File exportFileSystem(File outputFile) {
        try {
            this.workbook = new XSSFWorkbook(this.templateFile);
            this.converter.convert();
            this.writeFolders(this.converter.getFoldersToImport());
            this.writeDocuments(this.converter.getDocumentsToImport());
        }
        catch (IOException | InvalidFormatException e) {
            System.out.println(String.format("Impossible de lire le fichier %s", this.templateFile.getName()));
            e.printStackTrace();
        }
        this.writeExcelFile(outputFile);
        return outputFile;
    }

    private void writeExcelFile(File outputFile) {
        try (FileOutputStream os = new FileOutputStream(outputFile);){
            this.workbook.write(os);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeDocuments(List<DocumentWrapper> documents) {
        System.out.println("\u00c9criture des documents");
        XSSFSheet sheet = this.workbook.getSheet(DOCUMENT_PAGE_NAME);
        int rowNum = 2;
        for (DocumentWrapper document : documents) {
            Row row = sheet.createRow(rowNum++);
            this.createCell(row, 0, this.formatPath(document.getId()));
            this.createCell(row, 1, this.formatPath(document.getFolder()));
            this.createCell(row, 2, document.getTitle());
            this.createCell(row, 3, document.getType());
            this.createCell(row, 4, document.getSchema());
            this.createCell(row, 5, document.getFormattedCreationDate("yyyy-MM-dd HH:mm:ss"));
            this.createCell(row, 6, document.getFormattedModificationDate("yyyy-MM-dd HH:mm:ss"));
            this.createCell(row, 7, document.getContent());
        }
    }

    private void writeFolders(List<FolderWrapper> folders) {
        System.out.println("\u00c9criture des dossiers");
        XSSFSheet sheet = this.workbook.getSheet(FOLDERS_PAGE_NAME);
        int rowNum = 2;
        for (FolderWrapper folder : folders) {
            Row row = sheet.createRow(rowNum++);
            this.createCell(row, 0, this.formatPath(folder.getId()));
            this.createCell(row, 1, this.formatPath(folder.getParent()));
            this.createCell(row, 2, folder.getSchema());
            this.createCell(row, 3, folder.getType());
            this.createCell(row, 4, folder.getTitle());
            this.createCell(row, 6, folder.getAdministrativeUnit());
            this.createCell(row, 7, folder.getCategory());
            this.createCell(row, 8, folder.getRetentionRule());
            this.createCell(row, 9, folder.getOpeningDate());
        }
    }

    private void createCell(Row row, int position, String value) {
        if (value == null) {
            return;
        }
        Cell cell = row.createCell(position);
        cell.setCellValue(value);
    }

    private String formatPath(String path) {
        if (path == null) {
            return null;
        }
        if (path.length() < 2) {
            return path;
        }
        return path.substring(3);
    }
}

