/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.auth;

import com.constellio.plugin050.ImportClientLabels;
import com.constellio.plugin050.importscript.ClientLogWriter;
import com.constellio.plugin050.importscript.HttpConfigurations;
import com.constellio.plugin050.util.ImportScriptConstants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class ImportClientAuthentificationManager {
    private String token;
    private String serviceKey;
    private HttpConfigurations config;

    public ImportClientAuthentificationManager(HttpConfigurations config, String password) {
        this.config = config;
        this.obtainToken(password);
    }

    public void login() {
    }

    public String getServiceKey() {
        return this.serviceKey;
    }

    public String getToken() {
        return this.token;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HttpConfigurations obtainToken(String password) {
        try {
            HttpURLConnection http;
            URL url = new URL(this.config.getAdress() + "/generateToken");
            if (this.config.isConnectUsingSSL()) {
                this.setHttpsConfigurations();
                http = (HttpsURLConnection)url.openConnection();
            } else {
                http = (HttpURLConnection)url.openConnection();
            }
            http.setRequestMethod("GET");
            http.setRequestProperty("Content-Type", "application/json; utf-8");
            http.setRequestProperty("Accept", "application/json");
            http.setRequestProperty("username", this.config.getUsername());
            http.setRequestProperty("password", password);
            http.setRequestProperty("duration", "5h");
            try (BufferedReader br = new BufferedReader(new InputStreamReader(http.getInputStream(), "utf-8"));){
                StringBuilder response = new StringBuilder();
                String responseLine = null;
                while ((responseLine = br.readLine()) != null) {
                    response.append(responseLine.trim());
                }
                String token = ImportClientAuthentificationManager.parseResponse(response.toString(), "token");
                String serviceKey = ImportClientAuthentificationManager.parseResponse(response.toString(), "serviceKey");
                if (http.getResponseCode() != 200 || token == null) {
                    System.out.println(response.toString());
                    HttpConfigurations httpConfigurations = null;
                    return httpConfigurations;
                }
                this.token = token;
                this.serviceKey = serviceKey;
                HttpConfigurations httpConfigurations = this.config;
                return httpConfigurations;
            }
        }
        catch (IOException e) {
            System.out.println(ImportClientLabels.LOGIN_CANNOT_CONNECT);
            ClientLogWriter logWriter = new ClientLogWriter(ImportScriptConstants.LOG_FILE_NAME);
            logWriter.writeMessageToLogFile(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private static String parseResponse(String response, String field) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource source = new InputSource(new StringReader(response));
            Document document = builder.parse(source);
            Element root = document.getDocumentElement();
            return root.getElementsByTagName(field).item(0).getTextContent();
        }
        catch (Exception e) {
            return null;
        }
    }

    private void setHttpsConfigurations() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLS");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        try {
            sslContext.init(null, trustAllCerts, null);
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        if (this.config.isTrustAllCertificates()) {
            HttpsURLConnection.setDefaultHostnameVerifier((hostname, session) -> true);
        }
    }

    public static boolean testConnection() {
        return true;
    }

    public void setConfig(HttpConfigurations config) {
        this.config = config;
    }
}

