/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050;

import com.constellio.plugin050.ImportClientLabels;
import com.constellio.plugin050.auth.ImportClientAuthentificationManager;
import com.constellio.plugin050.importscript.HttpConfigurations;
import com.constellio.plugin050.importscript.ui.ImportClientProgram;
import com.constellio.plugin050.networkShareConversion.ui.NetworkShareExportProgram;
import com.constellio.plugin050.util.ImportConfigurationsManager;
import com.constellio.plugin050.util.ImportScriptConstants;
import java.io.Console;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Scanner;

public class ImportClientMain {
    private static String username;
    private static ImportConfigurationsManager configManager;
    private static ImportClientAuthentificationManager authentificationManager;
    private static HttpConfigurations config;

    public static void main(String[] args) {
        try {
            System.setErr(new PrintStream(new FileOutputStream(ImportScriptConstants.LOG_FILE_NAME, true), true));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        String version = System.getProperty("java.version");
        System.out.println(version);
        System.out.println("Utilitaire d'importation/exportation");
        System.out.println("-----------------------------------------");
        config = ImportClientMain.setupConfig();
        while (config.getToken() == null) {
            ImportClientMain.login();
        }
        System.out.println(ImportClientLabels.LOGIN_LOGGED_IN_MESSAGE);
        ImportClientMain.appSelectionMenu();
    }

    private static void appSelectionMenu() {
        while (true) {
            System.out.println("\nMenu principal");
            System.out.println("---------------");
            System.out.println("1. Client d'importation");
            System.out.println("2. Client d'exportation de partage r\u00e9seau");
            System.out.println("3. Informations du serveur");
            System.out.println("4. Quitter");
            Scanner input = new Scanner(System.in);
            String userChoice = input.nextLine();
            if (userChoice.equals("1")) {
                ImportClientProgram importClient = new ImportClientProgram(config);
                ImportClientProgram.main(null);
                continue;
            }
            if (userChoice.equals("2")) {
                NetworkShareExportProgram exportProgram = new NetworkShareExportProgram(config);
                NetworkShareExportProgram.main(null);
                continue;
            }
            if (userChoice.equals("3")) {
                ImportClientMain.setupConfig();
                continue;
            }
            if (userChoice.equals("4")) {
                System.exit(0);
                continue;
            }
            System.out.println("Commande invalide.");
        }
    }

    private static HttpConfigurations setupConfig() {
        System.out.println("Configurations du serveur");
        System.out.println("------------------------------");
        configManager = new ImportConfigurationsManager();
        System.out.println(String.format("Lecture du fichier de configurations...", new Object[0]));
        config = configManager.loadConfigFile(ImportScriptConstants.CONFIGURATIONS_FOLDER + ImportScriptConstants.CONFIG_FILE_NAME);
        if (config == null) {
            System.out.println("Le fichier de configuration est introuvable. Veuillez saisir les informations n\u00e9c\u00e9ssaires.");
            config = ImportClientMain.addConfigurationsManually();
        }
        System.out.println(String.format("Adresse du serveur: %s", config.getAdress()));
        return config;
    }

    public static void login() {
        String password;
        Scanner input = new Scanner(System.in);
        System.out.println(ImportClientLabels.LOGIN_USERNAME_PROMPT);
        username = input.nextLine();
        Console console = System.console();
        if (console != null) {
            password = new String(console.readPassword(ImportClientLabels.LOGIN_PASSWORD_PROMPT, new Object[0]));
        } else {
            System.out.println(ImportClientLabels.LOGIN_PASSWORD_PROMPT);
            password = input.nextLine();
        }
        config.setUsername(username);
        authentificationManager = new ImportClientAuthentificationManager(config, password);
        config.setToken(authentificationManager.getToken());
        config.setServiceKey(authentificationManager.getServiceKey());
    }

    private static HttpConfigurations addConfigurationsManually() {
        Scanner input = new Scanner(System.in);
        System.out.println("Adresse du serveur:");
        String host = input.nextLine();
        System.out.println("Port:");
        String port = input.nextLine();
        HttpConfigurations config = new HttpConfigurations(host, port);
        configManager.createNewConfigFile(config, ImportScriptConstants.CONFIGURATIONS_FOLDER + ImportScriptConstants.CONFIG_FILE_NAME);
        return config;
    }

    public static void buildAppStructure(String rootpath) {
        File root = new File(rootpath);
        File binDir = new File(root, ImportScriptConstants.BIN_FOLDER);
        File configDir = new File(root, ImportScriptConstants.CONFIGURATIONS_FOLDER);
        File dataDir = new File(root, ImportScriptConstants.DATA_FOLDER);
        File configFile = new File(configDir, ImportScriptConstants.CONFIG_FILE_NAME);
        try {
            binDir.mkdir();
            configDir.mkdir();
            dataDir.mkdir();
            configFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

