/*
 * Decompiled with CFR 0.152.
 */
package sun.net;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;

public final class InetAddressCachePolicy {
    private static final String cachePolicyProp = "networkaddress.cache.ttl";
    private static final String cachePolicyPropFallback = "sun.net.inetaddr.ttl";
    private static final String negativeCachePolicyProp = "networkaddress.cache.negative.ttl";
    private static final String negativeCachePolicyPropFallback = "sun.net.inetaddr.negative.ttl";
    public static final int FOREVER = -1;
    public static final int NEVER = 0;
    public static final int DEFAULT_POSITIVE = 30;
    private static int cachePolicy = -1;
    private static int negativeCachePolicy = 0;
    private static boolean propertySet;
    private static boolean propertyNegativeSet;

    public static synchronized int get() {
        return cachePolicy;
    }

    public static synchronized int getNegative() {
        return negativeCachePolicy;
    }

    public static synchronized void setIfNotSet(int n) {
        if (!propertySet) {
            InetAddressCachePolicy.checkValue(n, cachePolicy);
            cachePolicy = n;
        }
    }

    public static synchronized void setNegativeIfNotSet(int n) {
        if (!propertyNegativeSet) {
            negativeCachePolicy = n;
        }
    }

    private static void checkValue(int n, int n2) {
        if (n == -1) {
            return;
        }
        if (n2 == -1 || n < n2 || n < -1) {
            throw new SecurityException("can't make InetAddress cache more lax");
        }
    }

    static {
        Integer n = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                String string;
                try {
                    string = Security.getProperty(InetAddressCachePolicy.cachePolicyProp);
                    if (string != null) {
                        return Integer.valueOf(string);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    string = System.getProperty(InetAddressCachePolicy.cachePolicyPropFallback);
                    if (string != null) {
                        return Integer.decode(string);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return null;
            }
        });
        if (n != null) {
            cachePolicy = n;
            if (cachePolicy < 0) {
                cachePolicy = -1;
            }
            propertySet = true;
        } else if (System.getSecurityManager() == null) {
            cachePolicy = 30;
        }
        n = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                String string;
                try {
                    string = Security.getProperty(InetAddressCachePolicy.negativeCachePolicyProp);
                    if (string != null) {
                        return Integer.valueOf(string);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    string = System.getProperty(InetAddressCachePolicy.negativeCachePolicyPropFallback);
                    if (string != null) {
                        return Integer.decode(string);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                return null;
            }
        });
        if (n != null) {
            negativeCachePolicy = n;
            if (negativeCachePolicy < 0) {
                negativeCachePolicy = -1;
            }
            propertyNegativeSet = true;
        }
    }
}

