/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl;

import com.sun.security.sasl.CramMD5Base;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

final class CramMD5Client
extends CramMD5Base
implements SaslClient {
    private String username;

    CramMD5Client(String string, byte[] byArray) throws SaslException {
        if (string == null || byArray == null) {
            throw new SaslException("CRAM-MD5: authentication ID and password must be specified");
        }
        this.username = string;
        this.pw = byArray;
    }

    @Override
    public boolean hasInitialResponse() {
        return false;
    }

    @Override
    public byte[] evaluateChallenge(byte[] byArray) throws SaslException {
        if (this.completed) {
            throw new IllegalStateException("CRAM-MD5 authentication already completed");
        }
        if (this.aborted) {
            throw new IllegalStateException("CRAM-MD5 authentication previously aborted due to error");
        }
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "CRAMCLNT01:Received challenge: {0}", new String(byArray, "UTF8"));
            }
            String string = CramMD5Client.HMAC_MD5(this.pw, byArray);
            this.clearPassword();
            String string2 = this.username + " " + string;
            logger.log(Level.FINE, "CRAMCLNT02:Sending response: {0}", string2);
            this.completed = true;
            return string2.getBytes("UTF8");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.aborted = true;
            throw new SaslException("MD5 algorithm not available on platform", noSuchAlgorithmException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.aborted = true;
            throw new SaslException("UTF8 not available on platform", unsupportedEncodingException);
        }
    }
}

