/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp;

import com.adobe.xmp.XMPDateTime;
import com.adobe.xmp.XMPException;
import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.impl.Base64;
import com.adobe.xmp.impl.ISO8601Converter;
import com.adobe.xmp.impl.XMPUtilsImpl;
import com.adobe.xmp.options.PropertyOptions;

public class XMPUtils {
    private XMPUtils() {
    }

    public static String catenateArrayItems(XMPMeta xMPMeta, String string, String string2, String string3, String string4, boolean bl) throws XMPException {
        return XMPUtilsImpl.catenateArrayItems(xMPMeta, string, string2, string3, string4, bl);
    }

    public static void separateArrayItems(XMPMeta xMPMeta, String string, String string2, String string3, PropertyOptions propertyOptions, boolean bl) throws XMPException {
        XMPUtilsImpl.separateArrayItems(xMPMeta, string, string2, string3, propertyOptions, bl);
    }

    public static void removeProperties(XMPMeta xMPMeta, String string, String string2, boolean bl, boolean bl2) throws XMPException {
        XMPUtilsImpl.removeProperties(xMPMeta, string, string2, bl, bl2);
    }

    public static void appendProperties(XMPMeta xMPMeta, XMPMeta xMPMeta2, boolean bl, boolean bl2) throws XMPException {
        XMPUtils.appendProperties(xMPMeta, xMPMeta2, bl, bl2, false);
    }

    public static void appendProperties(XMPMeta xMPMeta, XMPMeta xMPMeta2, boolean bl, boolean bl2, boolean bl3) throws XMPException {
        XMPUtilsImpl.appendProperties(xMPMeta, xMPMeta2, bl, bl2, bl3);
    }

    public static boolean convertToBoolean(String string) throws XMPException {
        if (string == null || string.length() == 0) {
            throw new XMPException("Empty convert-string", 5);
        }
        string = string.toLowerCase();
        try {
            return Integer.parseInt(string) != 0;
        }
        catch (NumberFormatException numberFormatException) {
            return "true".equals(string) || "t".equals(string) || "on".equals(string) || "yes".equals(string);
        }
    }

    public static String convertFromBoolean(boolean bl) {
        return bl ? "True" : "False";
    }

    public static int convertToInteger(String string) throws XMPException {
        try {
            if (string == null || string.length() == 0) {
                throw new XMPException("Empty convert-string", 5);
            }
            if (string.startsWith("0x")) {
                return Integer.parseInt(string.substring(2), 16);
            }
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XMPException("Invalid integer string", 5);
        }
    }

    public static String convertFromInteger(int n) {
        return String.valueOf(n);
    }

    public static long convertToLong(String string) throws XMPException {
        try {
            if (string == null || string.length() == 0) {
                throw new XMPException("Empty convert-string", 5);
            }
            if (string.startsWith("0x")) {
                return Long.parseLong(string.substring(2), 16);
            }
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XMPException("Invalid long string", 5);
        }
    }

    public static String convertFromLong(long l) {
        return String.valueOf(l);
    }

    public static double convertToDouble(String string) throws XMPException {
        try {
            if (string == null || string.length() == 0) {
                throw new XMPException("Empty convert-string", 5);
            }
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new XMPException("Invalid double string", 5);
        }
    }

    public static String convertFromDouble(double d) {
        return String.valueOf(d);
    }

    public static XMPDateTime convertToDate(String string) throws XMPException {
        if (string == null || string.length() == 0) {
            throw new XMPException("Empty convert-string", 5);
        }
        return ISO8601Converter.parse(string);
    }

    public static String convertFromDate(XMPDateTime xMPDateTime) {
        return ISO8601Converter.render(xMPDateTime);
    }

    public static String encodeBase64(byte[] byArray) {
        return new String(Base64.encode(byArray));
    }

    public static byte[] decodeBase64(String string) throws XMPException {
        try {
            return Base64.decode(string.getBytes());
        }
        catch (Throwable throwable) {
            throw new XMPException("Invalid base64 string", 5, throwable);
        }
    }
}

