/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.importscript.data.excel;

import com.constellio.plugin050.importscript.data.excel.ExcelCell;
import java.util.Date;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;

public class Excel2007Cell
implements ExcelCell {
    private Cell cell;
    private DataFormatter formatter = new DataFormatter();

    public Excel2007Cell(Cell cell) {
        this.cell = cell;
    }

    @Override
    public int getColumn() {
        return this.cell.getColumnIndex();
    }

    @Override
    public String getContents() {
        CellType cellType = this.cell.getCellTypeEnum();
        if (cellType == CellType.BOOLEAN) {
            return this.cell.getBooleanCellValue() ? "true" : "false";
        }
        return this.formatter.formatCellValue(this.cell);
    }

    @Override
    public boolean isNotEmpty() {
        return this.cell.getCellType() != CellType.BLANK;
    }

    @Override
    public boolean isDate() {
        return this.cell.getCellType() == CellType.NUMERIC && DateUtil.isCellDateFormatted(this.cell);
    }

    @Override
    public Date getDate() {
        return this.cell.getDateCellValue();
    }
}

