/*
 * Decompiled with CFR 0.152.
 */
package com.constellio.plugin050.importscript.data.batchImport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ImportData {
    private int index;
    private String legacyId;
    private String schema;
    private Map<String, Object> fields;
    private Map<String, Object> options;

    public ImportData(int index, String schema, String legacyId, Map<String, Object> fieldsAndOptions) {
        this.legacyId = legacyId;
        this.index = index;
        this.fields = new HashMap<String, Object>();
        this.options = new HashMap<String, Object>();
        this.schema = schema;
        for (Map.Entry<String, Object> fieldOrOption : fieldsAndOptions.entrySet()) {
            if (fieldOrOption.getKey().startsWith("option_")) {
                this.options.put(StringUtils.substringAfter(fieldOrOption.getKey(), "option_"), fieldOrOption.getValue());
                continue;
            }
            this.fields.put(fieldOrOption.getKey(), fieldOrOption.getValue());
        }
    }

    public String getLegacyId() {
        return this.legacyId;
    }

    public int getIndex() {
        return this.index;
    }

    public String getSchema() {
        return this.schema;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public Map<String, Object> getFields() {
        return Collections.unmodifiableMap(this.fields);
    }

    public <T> T getValue(String key) {
        return (T)this.fields.get(key);
    }

    public <T> T getOption(String key) {
        return (T)this.options.get(key);
    }

    public <K, V> Map<K, V> getMap(String key) {
        Map values = (Map)this.getValue(key);
        return values == null ? new HashMap() : values;
    }

    public <V> List<V> getList(String key) {
        List values = (List)this.getValue(key);
        return values == null ? new ArrayList() : values;
    }
}

